package drr.regulation.asic.rewrite.trade.reports;

import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsFXProduct;
import drr.regulation.common.functions.Notional;
import drr.regulation.common.functions.PayoutLeg1;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.TradableProductForEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NotionalAmountLeg1Rule.NotionalAmountLeg1RuleDefault.class)
public abstract class NotionalAmountLeg1Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected IsFXProduct isFXProduct;
	@Inject protected Notional notional;
	@Inject protected PayoutLeg1 payoutLeg1;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected TradableProductForEvent tradableProductForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class NotionalAmountLeg1RuleDefault extends NotionalAmountLeg1Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(reportableEvent -> {
					final Boolean _boolean = isActionTypeTERM.evaluate(thenArg0.get());
					final MapperS<TradableProduct> _thenArg0;
					if ((_boolean == null ? false : _boolean)) {
						_thenArg0 = MapperS.of(beforeTradeForEvent.evaluate(thenArg0.get())).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct());
					} else {
						_thenArg0 = MapperS.of(tradableProductForEvent.evaluate(thenArg0.get()));
					}
					final MapperS<PayoutLegWithAuxiliary> _thenArg1 = _thenArg0
						.mapSingleToItem(item -> MapperS.of(payoutLeg1.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
					return _thenArg1
						.mapSingleToItem(item -> {
							if (areEqual(MapperS.of(notional.evaluate(item.get())).<BigDecimal>map("getValue", measure -> measure.getValue()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isFXProduct.evaluate(productForEvent.evaluate(reportableEvent.get()))))).getOrDefault(false)) {
								final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
								return bigInteger == null ? MapperS.<BigDecimal>ofNull() : MapperS.of(new BigDecimal(bigInteger));
							}
							return MapperS.of(notional.evaluate(item.get())).<BigDecimal>map("getValue", measure -> measure.getValue());
						});
				});
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
