package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.asic.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetLeg1ResolvablePriceQuantity;
import drr.regulation.common.functions.TradeForEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NotionalAmountScheduleLeg1Rule.NotionalAmountScheduleLeg1RuleDefault.class)
public abstract class NotionalAmountScheduleLeg1Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalAmountScheduleLeg1Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetLeg1ResolvablePriceQuantity getLeg1ResolvablePriceQuantity;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected NotionalAmountScheduleAmountLeg1Rule notionalAmountScheduleAmountLeg1Rule;
	@Inject protected NotionalAmountScheduleEffectiveDateLeg1Rule notionalAmountScheduleEffectiveDateLeg1Rule;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalAmountScheduleLeg1Report> evaluate(TransactionReportInstruction input) {
		List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalAmountScheduleLeg1Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalAmountScheduleLeg1Report::build).collect(Collectors.toList());
			objectValidator.validate(NotionalAmountScheduleLeg1Report.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalAmountScheduleLeg1RuleDefault extends NotionalAmountScheduleLeg1Rule {
		@Override
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> assignOutput(List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(getLeg1ResolvablePriceQuantity.evaluate(item.get())).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()));
			final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> thenArg3 = thenArg2
				.filterSingleNullSafe(item -> exists(item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
			final MapperC<DatedValue> thenArg4 = thenArg3
				.mapSingleToList(item -> item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()));
			final MapperC<QuantityReportablePeriod> thenArg5 = thenArg4
				.mapItem(notionalAmountPeriod -> MapperS.of(QuantityReportablePeriod.builder()
					.setPeriodValue(notionalAmountPeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).get())
					.setPeriodEffectiveDate(notionalAmountPeriod.<Date>map("getDate", datedValue -> datedValue.getDate()).get())
					.setPeriodEndDate(null)
					.build()));
			output = toBuilder(thenArg5
				.mapItem(item -> MapperS.of(NotionalAmountScheduleLeg1Report.builder()
					.setAmount(notionalAmountScheduleAmountLeg1Rule.evaluate(item.get()))
					.setEffectiveDate(notionalAmountScheduleEffectiveDateLeg1Rule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
