package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.datetime.Frequency;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NotionalQuantityLeg2Rule.NotionalQuantityLeg2RuleDefault.class)
public abstract class NotionalQuantityLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class NotionalQuantityLeg2RuleDefault extends NotionalQuantityLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<PriceQuantity> thenArg2 = thenArg1
				.mapSingleToItem(trade -> {
					final Boolean _boolean = isCommoditySwap.evaluate(productForTrade.evaluate(trade.get()));
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(commodityObservablePriceQuantity.evaluate(trade.<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(trade.get()))));
					}
					return MapperS.<PriceQuantity>ofNull();
				});
			final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg3 = thenArg2
				.mapSingleToList(item -> item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
			final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg4 = thenArg3
				.filterItemNullSafe(item -> exists(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).get());
			final MapperC<BigDecimal> thenArg5 = thenArg4
				.mapItem(quantitySchedule -> {
					if (exists(quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).getOrDefault(false)) {
						return quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
					}
					if (exists(quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule2 -> fieldWithMetaNonNegativeQuantitySchedule2 == null ? null : fieldWithMetaNonNegativeQuantitySchedule2.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue())).andNullSafe(areEqual(MapperS.of(distinct(quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule3 -> fieldWithMetaNonNegativeQuantitySchedule3 == null ? null : fieldWithMetaNonNegativeQuantitySchedule3.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue())).resultCount()), MapperS.of(1), CardinalityOperator.All)).getOrDefault(false)) {
						return quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule4 -> fieldWithMetaNonNegativeQuantitySchedule4 == null ? null : fieldWithMetaNonNegativeQuantitySchedule4.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue())
							.first();
					}
					return MapperS.<BigDecimal>ofNull();
				});
			final MapperS<BigDecimal> thenArg6 = MapperS.of(distinct(thenArg5).get());
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg6.get())).get();
			
			return output;
		}
	}
}
