package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.BarrierAndNotation;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class BarrierAndNotationTypeFormatValidator implements Validator<BarrierAndNotation> {

	private List<ComparisonResult> getComparisonResults(BarrierAndNotation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("singleBarrierPriceMonetary", o.getSingleBarrierPriceMonetary(), of(18), of(13), empty(), empty()), 
				checkNumber("singleBarrierPriceDecimal", o.getSingleBarrierPriceDecimal(), of(11), of(10), empty(), empty()), 
				checkNumber("lowerBarrierPriceMonetary", o.getLowerBarrierPriceMonetary(), of(18), of(13), empty(), empty()), 
				checkNumber("lowerBarrierPriceDecimal", o.getLowerBarrierPriceDecimal(), of(11), of(10), empty(), empty()), 
				checkNumber("upperBarrierPriceMonetary", o.getUpperBarrierPriceMonetary(), of(18), of(13), empty(), empty()), 
				checkNumber("upperBarrierPriceDecimal", o.getUpperBarrierPriceDecimal(), of(11), of(10), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, BarrierAndNotation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("BarrierAndNotation", ValidationResult.ValidationType.TYPE_FORMAT, "BarrierAndNotation", path, "", res.getError());
				}
				return success("BarrierAndNotation", ValidationResult.ValidationType.TYPE_FORMAT, "BarrierAndNotation", path, "");
			})
			.collect(toList());
	}

}
