package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class SpreadLeg1TypeFormatValidator implements Validator<SpreadLeg1> {

	private List<ComparisonResult> getComparisonResults(SpreadLeg1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("spreadLeg1Monetary", o.getSpreadLeg1Monetary(), of(18), of(13), empty(), empty()), 
				checkNumber("spreadLeg1Decimal", o.getSpreadLeg1Decimal(), of(11), of(10), empty(), empty()), 
				checkNumber("spreadLeg1Basis", o.getSpreadLeg1Basis(), of(5), empty(), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadLeg1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SpreadLeg1", ValidationResult.ValidationType.TYPE_FORMAT, "SpreadLeg1", path, "", res.getError());
				}
				return success("SpreadLeg1", ValidationResult.ValidationType.TYPE_FORMAT, "SpreadLeg1", path, "");
			})
			.collect(toList());
	}

}
