package drr.regulation.asic.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.OtherPaymentReport;
import drr.regulation.common.ActionTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1075_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1075_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1075_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1075_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType then if (otherPayment -> amount exists or otherPayment -> currency exists or otherPayment -> date exists or otherPayment -> payer exists or otherPayment -> receiver exists) then otherPayment -> paymentType exists else if (otherPayment -> amount count <> otherPayment -> paymentType count and otherPayment -> paymentType count <> otherPayment -> currency count and otherPayment -> currency count <> otherPayment -> date count and otherPayment -> payer count <> otherPayment -> receiver count) then False";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1075_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (exists(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount())).orNullSafe(exists(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()))).orNullSafe(exists(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<Date>map("getDate", otherPaymentReport -> otherPaymentReport.getDate()))).orNullSafe(exists(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()))).orNullSafe(exists(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()))).getOrDefault(false)) {
						return exists(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()));
					}
					if (notEqual(MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), CardinalityOperator.Any).andNullSafe(notEqual(MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()).resultCount()), CardinalityOperator.Any)).andNullSafe(notEqual(MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<Date>map("getDate", otherPaymentReport -> otherPaymentReport.getDate()).resultCount()), CardinalityOperator.Any)).andNullSafe(notEqual(MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), CardinalityOperator.Any)).getOrDefault(false)) {
						return ComparisonResult.ofNullSafe(MapperS.of(false));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1075_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
