package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("SpreadLeg1MonetaryOrDecimalOrBasis")
@ImplementedBy(SpreadLeg1MonetaryOrDecimalOrBasis.Default.class)
public interface SpreadLeg1MonetaryOrDecimalOrBasis extends Validator<SpreadLeg1> {
	
	String NAME = "SpreadLeg1MonetaryOrDecimalOrBasis";
	String DEFINITION = "optional choice spreadLeg1Monetary, spreadLeg1Decimal, spreadLeg1Basis";
	
	class Default implements SpreadLeg1MonetaryOrDecimalOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadLeg1 spreadLeg1) {
			ComparisonResult result = executeDataRule(spreadLeg1);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadLeg1", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadLeg1", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SpreadLeg1 spreadLeg1) {
			try {
				return choice(MapperS.of(spreadLeg1), Arrays.asList("spreadLeg1Monetary", "spreadLeg1Decimal", "spreadLeg1Basis"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SpreadLeg1MonetaryOrDecimalOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadLeg1 spreadLeg1) {
			return Collections.emptyList();
		}
	}
}
