package drr.regulation.asic.rewrite.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.PackageTransactionPrice;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class PackageTransactionPriceOnlyExistsValidator implements ValidatorWithArg<PackageTransactionPrice, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends PackageTransactionPrice> ValidationResult<PackageTransactionPrice> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("packageTransactionPriceMonetary", ExistenceChecker.isSet((BigDecimal) o.getPackageTransactionPriceMonetary()))
				.put("packageTransactionPriceDecimal", ExistenceChecker.isSet((BigDecimal) o.getPackageTransactionPriceDecimal()))
				.put("packageTransactionPriceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getPackageTransactionPriceNotation()))
				.put("packageTransactionPriceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPackageTransactionPriceCurrency()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("PackageTransactionPrice", ValidationResult.ValidationType.ONLY_EXISTS, "PackageTransactionPrice", path, "");
		}
		return failure("PackageTransactionPrice", ValidationResult.ValidationType.ONLY_EXISTS, "PackageTransactionPrice", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
