package drr.regulation.cftc.rewrite;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.cftc.rewrite.meta.ClearingExceptionsAndExemptionsCounterparty1ReportMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="ClearingExceptionsAndExemptionsCounterparty1Report", builder=ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilderImpl.class, version="5.55.0")
@RuneDataType(value="ClearingExceptionsAndExemptionsCounterparty1Report", model="drr", builder=ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilderImpl.class, version="5.55.0")
public interface ClearingExceptionsAndExemptionsCounterparty1Report extends RosettaModelObject {

	ClearingExceptionsAndExemptionsCounterparty1ReportMeta metaData = new ClearingExceptionsAndExemptionsCounterparty1ReportMeta();

	/*********************** Getter Methods  ***********************/
	String getValue();

	/*********************** Build Methods  ***********************/
	ClearingExceptionsAndExemptionsCounterparty1Report build();
	
	ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder toBuilder();
	
	static ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder builder() {
		return new ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ClearingExceptionsAndExemptionsCounterparty1Report> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ClearingExceptionsAndExemptionsCounterparty1Report> getType() {
		return ClearingExceptionsAndExemptionsCounterparty1Report.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("value"), String.class, getValue(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ClearingExceptionsAndExemptionsCounterparty1ReportBuilder extends ClearingExceptionsAndExemptionsCounterparty1Report, RosettaModelObjectBuilder {
		ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder setValue(String value);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("value"), String.class, getValue(), this);
		}
		

		ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder prune();
	}

	/*********************** Immutable Implementation of ClearingExceptionsAndExemptionsCounterparty1Report  ***********************/
	class ClearingExceptionsAndExemptionsCounterparty1ReportImpl implements ClearingExceptionsAndExemptionsCounterparty1Report {
		private final String value;
		
		protected ClearingExceptionsAndExemptionsCounterparty1ReportImpl(ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder builder) {
			this.value = builder.getValue();
		}
		
		@Override
		@RosettaAttribute(value="value", isRequired=true)
		@RuneAttribute(value="value", isRequired=true)
		public String getValue() {
			return value;
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty1Report build() {
			return this;
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder toBuilder() {
			ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder builder) {
			ofNullable(getValue()).ifPresent(builder::setValue);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingExceptionsAndExemptionsCounterparty1Report _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingExceptionsAndExemptionsCounterparty1Report {" +
				"value=" + this.value +
			'}';
		}
	}

	/*********************** Builder Implementation of ClearingExceptionsAndExemptionsCounterparty1Report  ***********************/
	class ClearingExceptionsAndExemptionsCounterparty1ReportBuilderImpl implements ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder {
	
		protected String value;
		
		@Override
		@RosettaAttribute(value="value", isRequired=true)
		@RuneAttribute(value="value", isRequired=true)
		public String getValue() {
			return value;
		}
		
		@RosettaAttribute(value="value", isRequired=true)
		@RuneAttribute(value="value", isRequired=true)
		@Override
		public ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder setValue(String _value) {
			this.value = _value == null ? null : _value;
			return this;
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty1Report build() {
			return new ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportImpl(this);
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getValue()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder o = (ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder) other;
			
			
			merger.mergeBasic(getValue(), o.getValue(), this::setValue);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingExceptionsAndExemptionsCounterparty1Report _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingExceptionsAndExemptionsCounterparty1ReportBuilder {" +
				"value=" + this.value +
			'}';
		}
	}
}
