package drr.regulation.cftc.rewrite;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.cftc.rewrite.meta.ClearingExceptionsAndExemptionsCounterparty2ReportMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="ClearingExceptionsAndExemptionsCounterparty2Report", builder=ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilderImpl.class, version="5.55.0")
@RuneDataType(value="ClearingExceptionsAndExemptionsCounterparty2Report", model="drr", builder=ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilderImpl.class, version="5.55.0")
public interface ClearingExceptionsAndExemptionsCounterparty2Report extends RosettaModelObject {

	ClearingExceptionsAndExemptionsCounterparty2ReportMeta metaData = new ClearingExceptionsAndExemptionsCounterparty2ReportMeta();

	/*********************** Getter Methods  ***********************/
	String getValue();

	/*********************** Build Methods  ***********************/
	ClearingExceptionsAndExemptionsCounterparty2Report build();
	
	ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder toBuilder();
	
	static ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder builder() {
		return new ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ClearingExceptionsAndExemptionsCounterparty2Report> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ClearingExceptionsAndExemptionsCounterparty2Report> getType() {
		return ClearingExceptionsAndExemptionsCounterparty2Report.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("value"), String.class, getValue(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ClearingExceptionsAndExemptionsCounterparty2ReportBuilder extends ClearingExceptionsAndExemptionsCounterparty2Report, RosettaModelObjectBuilder {
		ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder setValue(String value);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("value"), String.class, getValue(), this);
		}
		

		ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder prune();
	}

	/*********************** Immutable Implementation of ClearingExceptionsAndExemptionsCounterparty2Report  ***********************/
	class ClearingExceptionsAndExemptionsCounterparty2ReportImpl implements ClearingExceptionsAndExemptionsCounterparty2Report {
		private final String value;
		
		protected ClearingExceptionsAndExemptionsCounterparty2ReportImpl(ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder builder) {
			this.value = builder.getValue();
		}
		
		@Override
		@RosettaAttribute(value="value", isRequired=true)
		@RuneAttribute(value="value", isRequired=true)
		public String getValue() {
			return value;
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty2Report build() {
			return this;
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder toBuilder() {
			ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder builder) {
			ofNullable(getValue()).ifPresent(builder::setValue);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingExceptionsAndExemptionsCounterparty2Report _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingExceptionsAndExemptionsCounterparty2Report {" +
				"value=" + this.value +
			'}';
		}
	}

	/*********************** Builder Implementation of ClearingExceptionsAndExemptionsCounterparty2Report  ***********************/
	class ClearingExceptionsAndExemptionsCounterparty2ReportBuilderImpl implements ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder {
	
		protected String value;
		
		@Override
		@RosettaAttribute(value="value", isRequired=true)
		@RuneAttribute(value="value", isRequired=true)
		public String getValue() {
			return value;
		}
		
		@RosettaAttribute(value="value", isRequired=true)
		@RuneAttribute(value="value", isRequired=true)
		@Override
		public ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder setValue(String _value) {
			this.value = _value == null ? null : _value;
			return this;
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty2Report build() {
			return new ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportImpl(this);
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getValue()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder o = (ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder) other;
			
			
			merger.mergeBasic(getValue(), o.getValue(), this::setValue);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingExceptionsAndExemptionsCounterparty2Report _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingExceptionsAndExemptionsCounterparty2ReportBuilder {" +
				"value=" + this.value +
			'}';
		}
	}
}
