package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.reports.CDECDSIndexAttachmentPointRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(CDSIndexAttachmentPointRule.CDSIndexAttachmentPointRuleDefault.class)
public abstract class CDSIndexAttachmentPointRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDECDSIndexAttachmentPointRule cDECDSIndexAttachmentPointRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class CDSIndexAttachmentPointRuleDefault extends CDSIndexAttachmentPointRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			output = cDECDSIndexAttachmentPointRule.evaluate(input);
			
			return output;
		}
	}
}
