package drr.regulation.cftc.rewrite.reports;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;


@ImplementedBy(ClearingSwapUTIRule.ClearingSwapUTIRuleDefault.class)
public abstract class ClearingSwapUTIRule implements ReportFunction<AssignedIdentifier, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(AssignedIdentifier input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(AssignedIdentifier input);

	public static class ClearingSwapUTIRuleDefault extends ClearingSwapUTIRule {
		@Override
		protected String doEvaluate(AssignedIdentifier input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, AssignedIdentifier input) {
			final FieldWithMetaString fieldWithMetaString = MapperS.of(input)
				.mapSingleToItem(item -> item.<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier())).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
