package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.reports.CDEFirstExerciseDateRule;
import javax.inject.Inject;


@ImplementedBy(FirstExerciseDateRule.FirstExerciseDateRuleDefault.class)
public abstract class FirstExerciseDateRule implements ReportFunction<TransactionReportInstruction, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEFirstExerciseDateRule cDEFirstExerciseDateRule;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(TransactionReportInstruction input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(TransactionReportInstruction input);

	public static class FirstExerciseDateRuleDefault extends FirstExerciseDateRule {
		@Override
		protected Date doEvaluate(TransactionReportInstruction input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			output = MapperS.of(cDEFirstExerciseDateRule.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
