package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.standards.iosco.cde.reports.CDEOtherPaymentTypeRule;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentTypeRule.OtherPaymentTypeRuleDefault.class)
public abstract class OtherPaymentTypeRule implements ReportFunction<TransferState, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentTypeRule cDEOtherPaymentTypeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransferState input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransferState input);

	public static class OtherPaymentTypeRuleDefault extends OtherPaymentTypeRule {
		@Override
		protected String doEvaluate(TransferState input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransferState input) {
			output = cDEOtherPaymentTypeRule.evaluate(input);
			
			return output;
		}
	}
}
