package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.Trade;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.ObservationTerms;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityFixedPriceQuantity;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.FrequencyPeriod;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.QuantityFrequencyOrCalculationPeriod;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import javax.inject.Inject;


@ImplementedBy(QuantityFrequencyLeg1Rule.QuantityFrequencyLeg1RuleDefault.class)
public abstract class QuantityFrequencyLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityFixedPriceQuantity commodityFixedPriceQuantity;
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected FrequencyPeriod frequencyPeriod;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected QuantityFrequencyOrCalculationPeriod quantityFrequencyOrCalculationPeriod;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class QuantityFrequencyLeg1RuleDefault extends QuantityFrequencyLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			output = thenArg
				.mapSingleToItem(item -> {
					final Boolean boolean0 = qualify_Commodity_Swap_Basis.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(frequencyPeriod.evaluate(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg1.evaluate(productForTrade.evaluate(item.get()))), quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(commodityLeg1.evaluate(productForTrade.evaluate(item.get()))).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg1.evaluate(productForTrade.evaluate(item.get()))))));
					}
					final Boolean boolean1 = qualify_Commodity_Swap_FixedFloat.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(frequencyPeriod.evaluate(commodityFixedPriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()), quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(item.get()))).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityFixedPriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()))));
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swaption.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
						return MapperS.of(frequencyPeriod.evaluate(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))), quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(commodityLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))))));
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swaption.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
						return MapperS.of(frequencyPeriod.evaluate(commodityFixedPriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()), quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(commodityLeg2.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityFixedPriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get()))));
					}
					final Boolean boolean2 = qualify_Commodity_Option.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of(frequencyPeriod.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).get(), quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<ObservationTerms>map("getObservationTerms", optionPayout -> optionPayout.getObservationTerms()).<CalculationPeriodDates>map("getCalculationPeriodDates", observationTerms -> observationTerms.getCalculationPeriodDates()).get(), item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).get())));
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
