package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.MultiplyPrice;
import drr.standards.iosco.cde.reports.CDESpreadLeg2Rule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(SpreadLeg2Rule.SpreadLeg2RuleDefault.class)
public abstract class SpreadLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg2Rule cDESpreadLeg2Rule;
	@Inject protected GetSpreadLeg2NotationEnumRule getSpreadLeg2NotationEnumRule;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SpreadLeg2RuleDefault extends SpreadLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(multiplyPrice.evaluate(MapperS.of(cDESpreadLeg2Rule.evaluate(item.get())).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get(), getSpreadLeg2NotationEnumRule.evaluate(item.get())))).get();
			
			return output;
		}
	}
}
