package drr.regulation.cftc.rewrite.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CFTCGuidebookPart43Validator implements Validator<CFTCGuidebookPart43> {

	private List<ComparisonResult> getComparisonResults(CFTCGuidebookPart43 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("optionType", (String) o.getOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionStyle", (String) o.getOptionStyle() != null ? 1 : 0, 0, 1), 
				checkCardinality("assetClass", (String) o.getAssetClass() != null ? 1 : 0, 1, 1), 
				checkCardinality("mandatoryClearingIndicator", (Boolean) o.getMandatoryClearingIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("maturityDateOfTheUnderlier", (Date) o.getMaturityDateOfTheUnderlier() != null ? 1 : 0, 0, 1), 
				checkCardinality("largeNotionalOffFacilitySwapElectionIndicator", (Boolean) o.getLargeNotionalOffFacilitySwapElectionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("sefOrDcmIndicator", (Boolean) o.getSefOrDcmIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("sefOrDcmAnonymousExecutionIndicator", (Boolean) o.getSefOrDcmAnonymousExecutionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("messageType", (String) o.getMessageType() != null ? 1 : 0, 1, 1), 
				checkCardinality("sdMspIndicatorParty1", (Boolean) o.getSdMspIndicatorParty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("sdMspIndicatorParty2", (Boolean) o.getSdMspIndicatorParty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("physicalCommodityIndicator", (Boolean) o.getPhysicalCommodityIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementType", (String) o.getSettlementType() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebookPart43 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CFTCGuidebookPart43", ValidationResult.ValidationType.CARDINALITY, "CFTCGuidebookPart43", path, "", res.getError());
				}
				return success("CFTCGuidebookPart43", ValidationResult.ValidationType.CARDINALITY, "CFTCGuidebookPart43", path, "");
			})
			.collect(toList());
	}

}
