package drr.regulation.cftc.rewrite.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.ClearingExceptionsAndExemptionsCounterparty2Report;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ClearingExceptionsAndExemptionsCounterparty2ReportValidator implements Validator<ClearingExceptionsAndExemptionsCounterparty2Report> {

	private List<ComparisonResult> getComparisonResults(ClearingExceptionsAndExemptionsCounterparty2Report o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("value", (String) o.getValue() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ClearingExceptionsAndExemptionsCounterparty2Report o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ClearingExceptionsAndExemptionsCounterparty2Report", ValidationResult.ValidationType.CARDINALITY, "ClearingExceptionsAndExemptionsCounterparty2Report", path, "", res.getError());
				}
				return success("ClearingExceptionsAndExemptionsCounterparty2Report", ValidationResult.ValidationType.CARDINALITY, "ClearingExceptionsAndExemptionsCounterparty2Report", path, "");
			})
			.collect(toList());
	}

}
