package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("CFTCPart43TransactionReportDayCountConventionCondition")
@ImplementedBy(CFTCPart43TransactionReportDayCountConventionCondition.Default.class)
public interface CFTCPart43TransactionReportDayCountConventionCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportDayCountConventionCondition";
	String DEFINITION = "if [\"Credit\", \"InterestRate\"] any = cftcGuidebook -> assetClass then (fixedRateDayCountConventionLeg1 exists or floatingRateDayCountConventionLeg1 exists) and (fixedRateDayCountConventionLeg2 exists or floatingRateDayCountConventionLeg2 exists) else if [\"Commodity\", \"Equity\"] any = cftcGuidebook -> assetClass then ((if fixedRatePaymentFrequencyPeriodLeg1 exists then fixedRateDayCountConventionLeg1 exists else if floatingRatePaymentFrequencyPeriodLeg1 exists then floatingRateDayCountConventionLeg1 exists else fixedRateDayCountConventionLeg1 is absent and floatingRateDayCountConventionLeg1 is absent) and (if fixedRatePaymentFrequencyPeriodLeg2 exists then fixedRateDayCountConventionLeg2 exists else if floatingRatePaymentFrequencyPeriodLeg2 exists then floatingRateDayCountConventionLeg2 exists else fixedRateDayCountConventionLeg2 is absent and floatingRateDayCountConventionLeg2 is absent))";
	
	class Default implements CFTCPart43TransactionReportDayCountConventionCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate")), MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), CardinalityOperator.Any).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateDayCountConventionLeg1())).orNullSafe(exists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateDayCountConventionLeg1()))).andNullSafe(exists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateDayCountConventionLeg2())).orNullSafe(exists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateDayCountConventionLeg2()))));
				}
				if (areEqual(MapperC.<String>of(MapperS.of("Commodity"), MapperS.of("Equity")), MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), CardinalityOperator.Any).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRatePaymentFrequencyPeriodLeg1())).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateDayCountConventionLeg1()));
					} else if (exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getFloatingRatePaymentFrequencyPeriodLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRatePaymentFrequencyPeriodLeg1())).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateDayCountConventionLeg1()));
					} else {
						ifThenElseResult0 = notExists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateDayCountConventionLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateDayCountConventionLeg1())));
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRatePaymentFrequencyPeriodLeg2())).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateDayCountConventionLeg2()));
					} else if (exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getFloatingRatePaymentFrequencyPeriodLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRatePaymentFrequencyPeriodLeg2())).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateDayCountConventionLeg2()));
					} else {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateDayCountConventionLeg2())).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateDayCountConventionLeg2())));
					}
					return ifThenElseResult0.andNullSafe(ifThenElseResult1);
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportDayCountConventionCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
