package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("CFTCPart43TransactionReportOptionPremiumAmountCondition")
@ImplementedBy(CFTCPart43TransactionReportOptionPremiumAmountCondition.Default.class)
public interface CFTCPart43TransactionReportOptionPremiumAmountCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportOptionPremiumAmountCondition";
	String DEFINITION = "if cftcGuidebook -> optionStyle exists then optionPremiumAmount exists else optionPremiumAmount is absent";
	
	class Default implements CFTCPart43TransactionReportOptionPremiumAmountCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (exists(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getOptionStyle())).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getOptionPremiumAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getOptionPremiumAmount()));
				}
				return notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getOptionPremiumAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getOptionPremiumAmount()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportOptionPremiumAmountCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
