package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("CFTCPart45TransactionReportQuantityFrequencyCondition")
@ImplementedBy(CFTCPart45TransactionReportQuantityFrequencyCondition.Default.class)
public interface CFTCPart45TransactionReportQuantityFrequencyCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportQuantityFrequencyCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Commodity\" then ((if notionalQuantityLeg1 exists then quantityFrequencyLeg1 exists else True) and (if notionalQuantityLeg1 is absent then quantityFrequencyLeg1 is absent else True) and (if notionalQuantityLeg2 exists then quantityFrequencyLeg2 exists else True) and (if notionalQuantityLeg2 is absent then quantityFrequencyLeg2 is absent else True)) else quantityFrequencyLeg1 is absent and quantityFrequencyLeg2 is absent";
	
	class Default implements CFTCPart45TransactionReportQuantityFrequencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getNotionalQuantityLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNotionalQuantityLeg1())).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg1()));
					} else {
						ifThenElseResult0 = ComparisonResult.ofNullSafe(MapperS.of(true));
					}
					final ComparisonResult ifThenElseResult1;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getNotionalQuantityLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNotionalQuantityLeg1())).getOrDefault(false)) {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg1()));
					} else {
						ifThenElseResult1 = ComparisonResult.ofNullSafe(MapperS.of(true));
					}
					final ComparisonResult ifThenElseResult2;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getNotionalQuantityLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNotionalQuantityLeg2())).getOrDefault(false)) {
						ifThenElseResult2 = exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg2()));
					} else {
						ifThenElseResult2 = ComparisonResult.ofNullSafe(MapperS.of(true));
					}
					final ComparisonResult ifThenElseResult3;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getNotionalQuantityLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNotionalQuantityLeg2())).getOrDefault(false)) {
						ifThenElseResult3 = notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg2()));
					} else {
						ifThenElseResult3 = ComparisonResult.ofNullSafe(MapperS.of(true));
					}
					return ifThenElseResult0.andNullSafe(ifThenElseResult1).andNullSafe(ifThenElseResult2).andNullSafe(ifThenElseResult3);
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportQuantityFrequencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
