package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.OtherPaymentReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("CFTCPart45TransactionReportSpreadCondition")
@ImplementedBy(CFTCPart45TransactionReportSpreadCondition.Default.class)
public interface CFTCPart45TransactionReportSpreadCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportSpreadCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Credit\" then (if fixedRateLeg1 is absent and otherPayment -> paymentType any <> \"UFRO\" and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then spreadLeg1 exists else spreadLeg1 is absent) and (if fixedRateLeg2 is absent and otherPayment -> paymentType any <> \"UFRO\" and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then spreadLeg2 exists else spreadLeg2 is absent) else if cftcGuidebook -> assetClass = \"InterestRate\" then (if fixedRateLeg1 is absent and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then spreadLeg1 exists else spreadLeg1 is absent) and (if fixedRateLeg2 is absent and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then spreadLeg2 exists else spreadLeg2 is absent) else if cftcGuidebook -> assetClass = \"Equity\" and (price is absent and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent) then spreadLeg1 exists or spreadLeg2 exists else if cftcGuidebook -> assetClass = \"Commodity\" then (if (price is absent or fixedRateLeg1 is absent) and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then spreadLeg1 exists else spreadLeg1 is absent) and (if (price is absent or fixedRateLeg2 is absent) and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then spreadLeg2 exists else spreadLeg2 is absent) else spreadLeg1 is absent and spreadLeg2 is absent";
	
	class Default implements CFTCPart45TransactionReportSpreadCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Credit"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1())).andNullSafe(notEqual(MapperS.of(cFTCPart45TransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.Any)).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1()));
					} else {
						ifThenElseResult0 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1()));
					}
					final ComparisonResult ifThenElseResult1;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2())).andNullSafe(notEqual(MapperS.of(cFTCPart45TransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.Any)).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()));
					} else {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()));
					}
					return ifThenElseResult0.andNullSafe(ifThenElseResult1);
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("InterestRate"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult2;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1())).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult2 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1()));
					} else {
						ifThenElseResult2 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1()));
					}
					final ComparisonResult ifThenElseResult3;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2())).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult3 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()));
					} else {
						ifThenElseResult3 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()));
					}
					return ifThenElseResult2.andNullSafe(ifThenElseResult3);
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Equity"), CardinalityOperator.All).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice())).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle())))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1())).orNullSafe(exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2())));
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult4;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice())).orNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1()))).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult4 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1()));
					} else {
						ifThenElseResult4 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1()));
					}
					final ComparisonResult ifThenElseResult5;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice())).orNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2()))).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult5 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()));
					} else {
						ifThenElseResult5 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()));
					}
					return ifThenElseResult4.andNullSafe(ifThenElseResult5);
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportSpreadCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
