package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.meta.PriceReportablePeriodMeta;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="PriceReportablePeriod", builder=PriceReportablePeriod.PriceReportablePeriodBuilderImpl.class, version="5.55.0")
@RuneDataType(value="PriceReportablePeriod", model="drr", builder=PriceReportablePeriod.PriceReportablePeriodBuilderImpl.class, version="5.55.0")
public interface PriceReportablePeriod extends RosettaModelObject {

	PriceReportablePeriodMeta metaData = new PriceReportablePeriodMeta();

	/*********************** Getter Methods  ***********************/
	PriceAndNotation getPeriodValue();
	Date getPeriodEffectiveDate();
	Date getPeriodEndDate();

	/*********************** Build Methods  ***********************/
	PriceReportablePeriod build();
	
	PriceReportablePeriod.PriceReportablePeriodBuilder toBuilder();
	
	static PriceReportablePeriod.PriceReportablePeriodBuilder builder() {
		return new PriceReportablePeriod.PriceReportablePeriodBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PriceReportablePeriod> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PriceReportablePeriod> getType() {
		return PriceReportablePeriod.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("periodValue"), processor, PriceAndNotation.class, getPeriodValue());
		processor.processBasic(path.newSubPath("periodEffectiveDate"), Date.class, getPeriodEffectiveDate(), this);
		processor.processBasic(path.newSubPath("periodEndDate"), Date.class, getPeriodEndDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PriceReportablePeriodBuilder extends PriceReportablePeriod, RosettaModelObjectBuilder {
		PriceAndNotation.PriceAndNotationBuilder getOrCreatePeriodValue();
		@Override
		PriceAndNotation.PriceAndNotationBuilder getPeriodValue();
		PriceReportablePeriod.PriceReportablePeriodBuilder setPeriodValue(PriceAndNotation periodValue);
		PriceReportablePeriod.PriceReportablePeriodBuilder setPeriodEffectiveDate(Date periodEffectiveDate);
		PriceReportablePeriod.PriceReportablePeriodBuilder setPeriodEndDate(Date periodEndDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("periodValue"), processor, PriceAndNotation.PriceAndNotationBuilder.class, getPeriodValue());
			processor.processBasic(path.newSubPath("periodEffectiveDate"), Date.class, getPeriodEffectiveDate(), this);
			processor.processBasic(path.newSubPath("periodEndDate"), Date.class, getPeriodEndDate(), this);
		}
		

		PriceReportablePeriod.PriceReportablePeriodBuilder prune();
	}

	/*********************** Immutable Implementation of PriceReportablePeriod  ***********************/
	class PriceReportablePeriodImpl implements PriceReportablePeriod {
		private final PriceAndNotation periodValue;
		private final Date periodEffectiveDate;
		private final Date periodEndDate;
		
		protected PriceReportablePeriodImpl(PriceReportablePeriod.PriceReportablePeriodBuilder builder) {
			this.periodValue = ofNullable(builder.getPeriodValue()).map(f->f.build()).orElse(null);
			this.periodEffectiveDate = builder.getPeriodEffectiveDate();
			this.periodEndDate = builder.getPeriodEndDate();
		}
		
		@Override
		@RosettaAttribute(value="periodValue", isRequired=true)
		@RuneAttribute(value="periodValue", isRequired=true)
		public PriceAndNotation getPeriodValue() {
			return periodValue;
		}
		
		@Override
		@RosettaAttribute(value="periodEffectiveDate", isRequired=true)
		@RuneAttribute(value="periodEffectiveDate", isRequired=true)
		public Date getPeriodEffectiveDate() {
			return periodEffectiveDate;
		}
		
		@Override
		@RosettaAttribute("periodEndDate")
		@RuneAttribute("periodEndDate")
		public Date getPeriodEndDate() {
			return periodEndDate;
		}
		
		@Override
		public PriceReportablePeriod build() {
			return this;
		}
		
		@Override
		public PriceReportablePeriod.PriceReportablePeriodBuilder toBuilder() {
			PriceReportablePeriod.PriceReportablePeriodBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PriceReportablePeriod.PriceReportablePeriodBuilder builder) {
			ofNullable(getPeriodValue()).ifPresent(builder::setPeriodValue);
			ofNullable(getPeriodEffectiveDate()).ifPresent(builder::setPeriodEffectiveDate);
			ofNullable(getPeriodEndDate()).ifPresent(builder::setPeriodEndDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PriceReportablePeriod _that = getType().cast(o);
		
			if (!Objects.equals(periodValue, _that.getPeriodValue())) return false;
			if (!Objects.equals(periodEffectiveDate, _that.getPeriodEffectiveDate())) return false;
			if (!Objects.equals(periodEndDate, _that.getPeriodEndDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (periodValue != null ? periodValue.hashCode() : 0);
			_result = 31 * _result + (periodEffectiveDate != null ? periodEffectiveDate.hashCode() : 0);
			_result = 31 * _result + (periodEndDate != null ? periodEndDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PriceReportablePeriod {" +
				"periodValue=" + this.periodValue + ", " +
				"periodEffectiveDate=" + this.periodEffectiveDate + ", " +
				"periodEndDate=" + this.periodEndDate +
			'}';
		}
	}

	/*********************** Builder Implementation of PriceReportablePeriod  ***********************/
	class PriceReportablePeriodBuilderImpl implements PriceReportablePeriod.PriceReportablePeriodBuilder {
	
		protected PriceAndNotation.PriceAndNotationBuilder periodValue;
		protected Date periodEffectiveDate;
		protected Date periodEndDate;
		
		@Override
		@RosettaAttribute(value="periodValue", isRequired=true)
		@RuneAttribute(value="periodValue", isRequired=true)
		public PriceAndNotation.PriceAndNotationBuilder getPeriodValue() {
			return periodValue;
		}
		
		@Override
		public PriceAndNotation.PriceAndNotationBuilder getOrCreatePeriodValue() {
			PriceAndNotation.PriceAndNotationBuilder result;
			if (periodValue!=null) {
				result = periodValue;
			}
			else {
				result = periodValue = PriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="periodEffectiveDate", isRequired=true)
		@RuneAttribute(value="periodEffectiveDate", isRequired=true)
		public Date getPeriodEffectiveDate() {
			return periodEffectiveDate;
		}
		
		@Override
		@RosettaAttribute("periodEndDate")
		@RuneAttribute("periodEndDate")
		public Date getPeriodEndDate() {
			return periodEndDate;
		}
		
		@RosettaAttribute(value="periodValue", isRequired=true)
		@RuneAttribute(value="periodValue", isRequired=true)
		@Override
		public PriceReportablePeriod.PriceReportablePeriodBuilder setPeriodValue(PriceAndNotation _periodValue) {
			this.periodValue = _periodValue == null ? null : _periodValue.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="periodEffectiveDate", isRequired=true)
		@RuneAttribute(value="periodEffectiveDate", isRequired=true)
		@Override
		public PriceReportablePeriod.PriceReportablePeriodBuilder setPeriodEffectiveDate(Date _periodEffectiveDate) {
			this.periodEffectiveDate = _periodEffectiveDate == null ? null : _periodEffectiveDate;
			return this;
		}
		
		@RosettaAttribute("periodEndDate")
		@RuneAttribute("periodEndDate")
		@Override
		public PriceReportablePeriod.PriceReportablePeriodBuilder setPeriodEndDate(Date _periodEndDate) {
			this.periodEndDate = _periodEndDate == null ? null : _periodEndDate;
			return this;
		}
		
		@Override
		public PriceReportablePeriod build() {
			return new PriceReportablePeriod.PriceReportablePeriodImpl(this);
		}
		
		@Override
		public PriceReportablePeriod.PriceReportablePeriodBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PriceReportablePeriod.PriceReportablePeriodBuilder prune() {
			if (periodValue!=null && !periodValue.prune().hasData()) periodValue = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPeriodValue()!=null && getPeriodValue().hasData()) return true;
			if (getPeriodEffectiveDate()!=null) return true;
			if (getPeriodEndDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PriceReportablePeriod.PriceReportablePeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PriceReportablePeriod.PriceReportablePeriodBuilder o = (PriceReportablePeriod.PriceReportablePeriodBuilder) other;
			
			merger.mergeRosetta(getPeriodValue(), o.getPeriodValue(), this::setPeriodValue);
			
			merger.mergeBasic(getPeriodEffectiveDate(), o.getPeriodEffectiveDate(), this::setPeriodEffectiveDate);
			merger.mergeBasic(getPeriodEndDate(), o.getPeriodEndDate(), this::setPeriodEndDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PriceReportablePeriod _that = getType().cast(o);
		
			if (!Objects.equals(periodValue, _that.getPeriodValue())) return false;
			if (!Objects.equals(periodEffectiveDate, _that.getPeriodEffectiveDate())) return false;
			if (!Objects.equals(periodEndDate, _that.getPeriodEndDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (periodValue != null ? periodValue.hashCode() : 0);
			_result = 31 * _result + (periodEffectiveDate != null ? periodEffectiveDate.hashCode() : 0);
			_result = 31 * _result + (periodEndDate != null ? periodEndDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PriceReportablePeriodBuilder {" +
				"periodValue=" + this.periodValue + ", " +
				"periodEffectiveDate=" + this.periodEffectiveDate + ", " +
				"periodEndDate=" + this.periodEndDate +
			'}';
		}
	}
}
