package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.ReportableValuationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="ReportableValuation", builder=ReportableValuation.ReportableValuationBuilderImpl.class, version="5.55.0")
@RuneDataType(value="ReportableValuation", model="drr", builder=ReportableValuation.ReportableValuationBuilderImpl.class, version="5.55.0")
public interface ReportableValuation extends RosettaModelObject {

	ReportableValuationMeta metaData = new ReportableValuationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * The reportable valuation information
	 */
	ValuationDetails getValuationDetails();
	/**
	 * Additional information required for a reportable transaction, including the reporting regime.
	 */
	ReportableInformation getReportableInformation();

	/*********************** Build Methods  ***********************/
	ReportableValuation build();
	
	ReportableValuation.ReportableValuationBuilder toBuilder();
	
	static ReportableValuation.ReportableValuationBuilder builder() {
		return new ReportableValuation.ReportableValuationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ReportableValuation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ReportableValuation> getType() {
		return ReportableValuation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.class, getValuationDetails());
		processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, getReportableInformation());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ReportableValuationBuilder extends ReportableValuation, RosettaModelObjectBuilder {
		ValuationDetails.ValuationDetailsBuilder getOrCreateValuationDetails();
		@Override
		ValuationDetails.ValuationDetailsBuilder getValuationDetails();
		ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation();
		@Override
		ReportableInformation.ReportableInformationBuilder getReportableInformation();
		ReportableValuation.ReportableValuationBuilder setValuationDetails(ValuationDetails valuationDetails);
		ReportableValuation.ReportableValuationBuilder setReportableInformation(ReportableInformation reportableInformation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.ValuationDetailsBuilder.class, getValuationDetails());
			processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, getReportableInformation());
		}
		

		ReportableValuation.ReportableValuationBuilder prune();
	}

	/*********************** Immutable Implementation of ReportableValuation  ***********************/
	class ReportableValuationImpl implements ReportableValuation {
		private final ValuationDetails valuationDetails;
		private final ReportableInformation reportableInformation;
		
		protected ReportableValuationImpl(ReportableValuation.ReportableValuationBuilder builder) {
			this.valuationDetails = ofNullable(builder.getValuationDetails()).map(f->f.build()).orElse(null);
			this.reportableInformation = ofNullable(builder.getReportableInformation()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("valuationDetails")
		@RuneAttribute("valuationDetails")
		public ValuationDetails getValuationDetails() {
			return valuationDetails;
		}
		
		@Override
		@RosettaAttribute(value="reportableInformation", isRequired=true)
		@RuneAttribute(value="reportableInformation", isRequired=true)
		public ReportableInformation getReportableInformation() {
			return reportableInformation;
		}
		
		@Override
		public ReportableValuation build() {
			return this;
		}
		
		@Override
		public ReportableValuation.ReportableValuationBuilder toBuilder() {
			ReportableValuation.ReportableValuationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ReportableValuation.ReportableValuationBuilder builder) {
			ofNullable(getValuationDetails()).ifPresent(builder::setValuationDetails);
			ofNullable(getReportableInformation()).ifPresent(builder::setReportableInformation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReportableValuation _that = getType().cast(o);
		
			if (!Objects.equals(valuationDetails, _that.getValuationDetails())) return false;
			if (!Objects.equals(reportableInformation, _that.getReportableInformation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (valuationDetails != null ? valuationDetails.hashCode() : 0);
			_result = 31 * _result + (reportableInformation != null ? reportableInformation.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReportableValuation {" +
				"valuationDetails=" + this.valuationDetails + ", " +
				"reportableInformation=" + this.reportableInformation +
			'}';
		}
	}

	/*********************** Builder Implementation of ReportableValuation  ***********************/
	class ReportableValuationBuilderImpl implements ReportableValuation.ReportableValuationBuilder {
	
		protected ValuationDetails.ValuationDetailsBuilder valuationDetails;
		protected ReportableInformation.ReportableInformationBuilder reportableInformation;
		
		@Override
		@RosettaAttribute("valuationDetails")
		@RuneAttribute("valuationDetails")
		public ValuationDetails.ValuationDetailsBuilder getValuationDetails() {
			return valuationDetails;
		}
		
		@Override
		public ValuationDetails.ValuationDetailsBuilder getOrCreateValuationDetails() {
			ValuationDetails.ValuationDetailsBuilder result;
			if (valuationDetails!=null) {
				result = valuationDetails;
			}
			else {
				result = valuationDetails = ValuationDetails.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="reportableInformation", isRequired=true)
		@RuneAttribute(value="reportableInformation", isRequired=true)
		public ReportableInformation.ReportableInformationBuilder getReportableInformation() {
			return reportableInformation;
		}
		
		@Override
		public ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation() {
			ReportableInformation.ReportableInformationBuilder result;
			if (reportableInformation!=null) {
				result = reportableInformation;
			}
			else {
				result = reportableInformation = ReportableInformation.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute("valuationDetails")
		@RuneAttribute("valuationDetails")
		@Override
		public ReportableValuation.ReportableValuationBuilder setValuationDetails(ValuationDetails _valuationDetails) {
			this.valuationDetails = _valuationDetails == null ? null : _valuationDetails.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="reportableInformation", isRequired=true)
		@RuneAttribute(value="reportableInformation", isRequired=true)
		@Override
		public ReportableValuation.ReportableValuationBuilder setReportableInformation(ReportableInformation _reportableInformation) {
			this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
			return this;
		}
		
		@Override
		public ReportableValuation build() {
			return new ReportableValuation.ReportableValuationImpl(this);
		}
		
		@Override
		public ReportableValuation.ReportableValuationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReportableValuation.ReportableValuationBuilder prune() {
			if (valuationDetails!=null && !valuationDetails.prune().hasData()) valuationDetails = null;
			if (reportableInformation!=null && !reportableInformation.prune().hasData()) reportableInformation = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getValuationDetails()!=null && getValuationDetails().hasData()) return true;
			if (getReportableInformation()!=null && getReportableInformation().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReportableValuation.ReportableValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ReportableValuation.ReportableValuationBuilder o = (ReportableValuation.ReportableValuationBuilder) other;
			
			merger.mergeRosetta(getValuationDetails(), o.getValuationDetails(), this::setValuationDetails);
			merger.mergeRosetta(getReportableInformation(), o.getReportableInformation(), this::setReportableInformation);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReportableValuation _that = getType().cast(o);
		
			if (!Objects.equals(valuationDetails, _that.getValuationDetails())) return false;
			if (!Objects.equals(reportableInformation, _that.getReportableInformation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (valuationDetails != null ? valuationDetails.hashCode() : 0);
			_result = 31 * _result + (reportableInformation != null ? reportableInformation.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReportableValuationBuilder {" +
				"valuationDetails=" + this.valuationDetails + ", " +
				"reportableInformation=" + this.reportableInformation +
			'}';
		}
	}
}
