package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CommodityFrequencyMultiplier.CommodityFrequencyMultiplierDefault.class)
public abstract class CommodityFrequencyMultiplier implements RosettaFunction {

	/**
	* @param commodityPayout 
	* @return periodMultiplier 
	*/
	public Integer evaluate(CommodityPayout commodityPayout) {
		Integer periodMultiplier = doEvaluate(commodityPayout);
		
		return periodMultiplier;
	}

	protected abstract Integer doEvaluate(CommodityPayout commodityPayout);

	public static class CommodityFrequencyMultiplierDefault extends CommodityFrequencyMultiplier {
		@Override
		protected Integer doEvaluate(CommodityPayout commodityPayout) {
			Integer periodMultiplier = null;
			return assignOutput(periodMultiplier, commodityPayout);
		}
		
		protected Integer assignOutput(Integer periodMultiplier, CommodityPayout commodityPayout) {
			if (exists(MapperS.of(commodityPayout).<ResolvablePriceQuantity>map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).getOrDefault(false)) {
				periodMultiplier = MapperS.of(commodityPayout).<ResolvablePriceQuantity>map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier()).get();
			} else {
				periodMultiplier = null;
			}
			
			return periodMultiplier;
		}
	}
}
