package drr.regulation.common.functions;

import cdm.event.common.Trade;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetLeg1ResolvablePriceQuantity.GetLeg1ResolvablePriceQuantityDefault.class)
public abstract class GetLeg1ResolvablePriceQuantity implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXLeg1 fXLeg1;
	@Inject protected FXSwapLeg1 fXSwapLeg1;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsCap isCap;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsEquity isEquity;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsFloor isFloor;
	@Inject protected IsGenericIRS isGenericIRS;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param trade 
	* @return priceQuantity 
	*/
	public ResolvablePriceQuantity evaluate(Trade trade) {
		ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantityBuilder = doEvaluate(trade);
		
		final ResolvablePriceQuantity priceQuantity;
		if (priceQuantityBuilder == null) {
			priceQuantity = null;
		} else {
			priceQuantity = priceQuantityBuilder.build();
			objectValidator.validate(ResolvablePriceQuantity.class, priceQuantity);
		}
		
		return priceQuantity;
	}

	protected abstract ResolvablePriceQuantity.ResolvablePriceQuantityBuilder doEvaluate(Trade trade);

	protected abstract MapperS<? extends Product> product(Trade trade);

	public static class GetLeg1ResolvablePriceQuantityDefault extends GetLeg1ResolvablePriceQuantity {
		@Override
		protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder doEvaluate(Trade trade) {
			ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity = ResolvablePriceQuantity.builder();
			return assignOutput(priceQuantity, trade);
		}
		
		protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder assignOutput(ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity, Trade trade) {
			final Boolean boolean0 = isIRSwaption.evaluate(product(trade).get());
			if ((boolean0 == null ? false : boolean0)) {
				final MapperS<InterestRatePayout> thenArg0 = MapperS.of(underlierForProduct.evaluate(product(trade).get()))
					.mapSingleToItem(item -> MapperS.of(interestRateLeg1.evaluate(item.get())));
				priceQuantity = toBuilder(thenArg0
					.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity())).get());
			} else if (ComparisonResult.ofNullSafe(MapperS.of(isGenericIRS.evaluate(product(trade).get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCap.evaluate(product(trade).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isFloor.evaluate(product(trade).get())))).getOrDefault(false)) {
				priceQuantity = toBuilder(MapperS.of(interestRateLeg1.evaluate(product(trade).get()))
					.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity())).get());
			} else {
				final Boolean boolean1 = isCreditSwaption.evaluate(product(trade).get());
				if ((boolean1 == null ? false : boolean1)) {
					final MapperS<CreditDefaultPayout> thenArg1 = MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product(trade).get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
					priceQuantity = toBuilder(thenArg1
						.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity())).get());
				} else {
					final Boolean boolean2 = isCreditDefaultSwap.evaluate(product(trade).get());
					if ((boolean2 == null ? false : boolean2)) {
						priceQuantity = toBuilder(MapperS.of(economicTermsForProduct.evaluate(product(trade).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<ResolvablePriceQuantity>map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity()).get());
					} else {
						final Boolean boolean3 = isEquity.evaluate(product(trade).get());
						if ((boolean3 == null ? false : boolean3)) {
							priceQuantity = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product(trade).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", performancePayout -> performancePayout.getPriceQuantity()).get());
						} else if (ComparisonResult.ofNullSafe(MapperS.of(isVolatilitySwap.evaluate(product(trade).get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isVarianceSwap.evaluate(product(trade).get())))).getOrDefault(false)) {
							priceQuantity = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product(trade).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", performancePayout -> performancePayout.getPriceQuantity()).get());
						} else {
							final Boolean boolean4 = isFXForward.evaluate(product(trade).get());
							if ((boolean4 == null ? false : boolean4)) {
								priceQuantity = toBuilder(MapperS.of(fXLeg1.evaluate(product(trade).get()))
									.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity())).get());
							} else {
								final Boolean boolean5 = isFXOption.evaluate(product(trade).get());
								if ((boolean5 == null ? false : boolean5)) {
									priceQuantity = toBuilder(MapperS.of(fXLeg1.evaluate(product(trade).get()))
										.mapSingleToItem(item -> item.<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity())).get());
								} else {
									final Boolean boolean6 = isFXSwap.evaluate(product(trade).get());
									if ((boolean6 == null ? false : boolean6)) {
										priceQuantity = toBuilder(MapperS.of(fXSwapLeg1.evaluate(product(trade).get())).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).get());
									} else {
										final Boolean boolean7 = qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(product(trade).get()));
										if ((boolean7 == null ? false : boolean7)) {
											priceQuantity = toBuilder(MapperS.of(fixedPriceLeg1.evaluate(product(trade).get())).<ResolvablePriceQuantity>map("getPriceQuantity", fixedPricePayout -> fixedPricePayout.getPriceQuantity()).get());
										} else {
											final Boolean boolean8 = qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(product(trade).get()));
											if ((boolean8 == null ? false : boolean8)) {
												priceQuantity = toBuilder(MapperS.of(commodityLeg1.evaluate(product(trade).get())).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).get());
											} else {
												final Boolean boolean9 = qualify_Commodity_Option.evaluate(economicTermsForProduct.evaluate(product(trade).get()));
												if ((boolean9 == null ? false : boolean9)) {
													priceQuantity = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product(trade).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).get());
												} else {
													final Boolean boolean10 = qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(product(trade).get()));
													if ((boolean10 == null ? false : boolean10)) {
														final Boolean boolean11 = qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product(trade).get())));
														if ((boolean11 == null ? false : boolean11)) {
															priceQuantity = toBuilder(MapperS.of(fixedPriceLeg1.evaluate(underlierForProduct.evaluate(product(trade).get()))).<ResolvablePriceQuantity>map("getPriceQuantity", fixedPricePayout -> fixedPricePayout.getPriceQuantity()).get());
														} else {
															final Boolean boolean12 = qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product(trade).get())));
															if ((boolean12 == null ? false : boolean12)) {
																priceQuantity = toBuilder(MapperS.of(commodityLeg1.evaluate(underlierForProduct.evaluate(product(trade).get()))).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).get());
															} else {
																priceQuantity = null;
															}
														}
													} else {
														final Boolean boolean13 = qualify_Commodity_Forward.evaluate(economicTermsForProduct.evaluate(product(trade).get()));
														if ((boolean13 == null ? false : boolean13)) {
															final Boolean boolean14 = isCommodityFixedPriceForward.evaluate(product(trade).get());
															if ((boolean14 == null ? false : boolean14)) {
																priceQuantity = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product(trade).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", fixedPricePayout -> fixedPricePayout.getPriceQuantity()).get());
															} else {
																final Boolean boolean15 = isCommodityFloatingPriceForward.evaluate(product(trade).get());
																if ((boolean15 == null ? false : boolean15)) {
																	priceQuantity = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product(trade).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).get());
																} else {
																	priceQuantity = null;
																}
															}
														} else {
															final Boolean boolean16 = isSingleCommodityPayoutProduct.evaluate(product(trade).get());
															if ((boolean16 == null ? false : boolean16)) {
																priceQuantity = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product(trade).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).get());
															} else {
																priceQuantity = null;
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			
			return Optional.ofNullable(priceQuantity)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends Product> product(Trade trade) {
			return MapperS.of(productForTrade.evaluate(trade));
		}
	}
}
