package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.standards.iosco.cde.reports.CDEPriceNotationEnumRule;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetPriceNotationEnum.GetPriceNotationEnumDefault.class)
public abstract class GetPriceNotationEnum implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPriceNotationEnumRule cDEPriceNotationEnumRule;

	/**
	* @param reportableEvent 
	* @return priceNotationEnum 
	*/
	public PriceNotationEnum evaluate(ReportableEvent reportableEvent) {
		PriceNotationEnum priceNotationEnum = doEvaluate(reportableEvent);
		
		return priceNotationEnum;
	}

	protected abstract PriceNotationEnum doEvaluate(ReportableEvent reportableEvent);

	public static class GetPriceNotationEnumDefault extends GetPriceNotationEnum {
		@Override
		protected PriceNotationEnum doEvaluate(ReportableEvent reportableEvent) {
			PriceNotationEnum priceNotationEnum = null;
			return assignOutput(priceNotationEnum, reportableEvent);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum priceNotationEnum, ReportableEvent reportableEvent) {
			if (areEqual(MapperS.of(cDEPriceNotationEnumRule.evaluate(reportableEvent)), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
				priceNotationEnum = PriceNotationEnum.DECIMAL;
			} else {
				priceNotationEnum = cDEPriceNotationEnumRule.evaluate(reportableEvent);
			}
			
			return priceNotationEnum;
		}
	}
}
