package drr.regulation.common.functions;

import cdm.base.datetime.PeriodExtendedEnum;
import cdm.product.common.schedule.ResetFrequency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ResetFrequencyPeriod.ResetFrequencyPeriodDefault.class)
public abstract class ResetFrequencyPeriod implements RosettaFunction {

	/**
	* @param resetFrequency 
	* @return period 
	*/
	public String evaluate(ResetFrequency resetFrequency) {
		String period = doEvaluate(resetFrequency);
		
		return period;
	}

	protected abstract String doEvaluate(ResetFrequency resetFrequency);

	public static class ResetFrequencyPeriodDefault extends ResetFrequencyPeriod {
		@Override
		protected String doEvaluate(ResetFrequency resetFrequency) {
			String period = null;
			return assignOutput(period, resetFrequency);
		}
		
		protected String assignOutput(String period, ResetFrequency resetFrequency) {
			if (areEqual(MapperS.of(resetFrequency).<PeriodExtendedEnum>map("getPeriod", _resetFrequency -> _resetFrequency.getPeriod()), MapperS.of(PeriodExtendedEnum.D), CardinalityOperator.All).getOrDefault(false)) {
				period = "DAIL";
			} else if (areEqual(MapperS.of(resetFrequency).<PeriodExtendedEnum>map("getPeriod", _resetFrequency -> _resetFrequency.getPeriod()), MapperS.of(PeriodExtendedEnum.W), CardinalityOperator.All).getOrDefault(false)) {
				period = "WEEK";
			} else if (areEqual(MapperS.of(resetFrequency).<PeriodExtendedEnum>map("getPeriod", _resetFrequency -> _resetFrequency.getPeriod()), MapperS.of(PeriodExtendedEnum.M), CardinalityOperator.All).getOrDefault(false)) {
				period = "MNTH";
			} else if (areEqual(MapperS.of(resetFrequency).<PeriodExtendedEnum>map("getPeriod", _resetFrequency -> _resetFrequency.getPeriod()), MapperS.of(PeriodExtendedEnum.Y), CardinalityOperator.All).getOrDefault(false)) {
				period = "YEAR";
			} else if (areEqual(MapperS.of(resetFrequency).<PeriodExtendedEnum>map("getPeriod", _resetFrequency -> _resetFrequency.getPeriod()), MapperS.of(PeriodExtendedEnum.T), CardinalityOperator.All).getOrDefault(false)) {
				period = "EXPI";
			} else {
				period = null;
			}
			
			return period;
		}
	}
}
