package drr.regulation.common.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.ESMATransactionInformation;
import drr.regulation.common.validation.ESMATransactionInformationTypeFormatValidator;
import drr.regulation.common.validation.ESMATransactionInformationValidator;
import drr.regulation.common.validation.exists.ESMATransactionInformationOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.55.0
 */
@RosettaMeta(model=ESMATransactionInformation.class)
public class ESMATransactionInformationMeta implements RosettaMetaData<ESMATransactionInformation> {

	@Override
	public List<Validator<? super ESMATransactionInformation>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super ESMATransactionInformation, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ESMATransactionInformation> validator(ValidatorFactory factory) {
		return factory.<ESMATransactionInformation>create(ESMATransactionInformationValidator.class);
	}

	@Override
	public Validator<? super ESMATransactionInformation> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ESMATransactionInformation>create(ESMATransactionInformationTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ESMATransactionInformation> validator() {
		return new ESMATransactionInformationValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ESMATransactionInformation> typeFormatValidator() {
		return new ESMATransactionInformationTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ESMATransactionInformation, Set<String>> onlyExistsValidator() {
		return new ESMATransactionInformationOnlyExistsValidator();
	}
}
