package drr.regulation.common.rates.functions;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ISOFloatingRateIndexEnum;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(FloatingRateIndex_ISDA_To_EMIR.FloatingRateIndex_ISDA_To_EMIRDefault.class)
public abstract class FloatingRateIndex_ISDA_To_EMIR implements RosettaFunction {

	/**
	* @param floatingRateIndexISDA 
	* @return floatingRateIndexISO 
	*/
	public ISOFloatingRateIndexEnum evaluate(FloatingRateIndexEnum floatingRateIndexISDA) {
		ISOFloatingRateIndexEnum floatingRateIndexISO = doEvaluate(floatingRateIndexISDA);
		
		return floatingRateIndexISO;
	}

	protected abstract ISOFloatingRateIndexEnum doEvaluate(FloatingRateIndexEnum floatingRateIndexISDA);

	public static class FloatingRateIndex_ISDA_To_EMIRDefault extends FloatingRateIndex_ISDA_To_EMIR {
		@Override
		protected ISOFloatingRateIndexEnum doEvaluate(FloatingRateIndexEnum floatingRateIndexISDA) {
			ISOFloatingRateIndexEnum floatingRateIndexISO = null;
			return assignOutput(floatingRateIndexISO, floatingRateIndexISDA);
		}
		
		protected ISOFloatingRateIndexEnum assignOutput(ISOFloatingRateIndexEnum floatingRateIndexISO, FloatingRateIndexEnum floatingRateIndexISDA) {
			if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_BBR_AUBBSW), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_BBR_BBSW), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_BBR_BBSW_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_BBSW), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.BBSW;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HUF_BUBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HUF_BUBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HUF_BUBOR_REUTERS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.BUBO;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CAD_BA_CDOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CAD_BA_CDOR_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CAD_CDOR), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.CDOR;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR2), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR_2_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR2_DKNA13), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR_DKNA13), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR_DKNA_13_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.DKK_CIBOR_REFERENCE_BANKS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.CIBO;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS_H_15), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS_H_15_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_FEDERAL_FUNDS_REFERENCE_DEALERS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.EFFR;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EONIA), CardinalityOperator.All).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.EONA;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EONIA_SWAP_INDEX), CardinalityOperator.All).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.EONS;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURO_STR), CardinalityOperator.All).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.ESTR;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ACT_365), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ACT_365_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_REUTERS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_TELERATE), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.EURI;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_ISDAFIX_3_SWAP_RATE), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_ISDAFIX_3_SWAP_RATE_3_00), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.ISDA;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ZAR_JIBAR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ZAR_JIBAR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ZAR_JIBAR_SAFEX), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.JIBA;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_LIBOR_BBA), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_LIBOR_BBA_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_LIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CAD_LIBOR_BBA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CAD_LIBOR_BBA_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CAD_LIBOR_BBA_SWAP_MARKER), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CAD_LIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR_BBA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR_BBA_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR_ISDA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_LIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_LIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_LIBOR_BBA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_LIBOR_BBA_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_LIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_BBA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_BBA_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_ISDA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_BBA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_BBA_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_FRASETT), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_ISDA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_QUOTING_BANKS_LIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.MYR_KLIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.MYR_KLIBOR_BNM), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.MYR_KLIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.TRY_TRLIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_LIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_BBA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_BBA_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_ISDA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_LIBO), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_REFERENCE_BANKS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.LIBO;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_MUNICIPAL_SWAP_INDEX), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_MUNICIPAL_SWAP_LIBOR_RATIO_11_00_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_MUNICIPAL_SWAP_RATE_11_00_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_SIFMA_MUNICIPAL_SWAP_INDEX), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.MAAA;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RUB_MOS_PRIME), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RUB_MOSPRIME_NFEA), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RUB_MOSPRIME_REFERENCE_BANKS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.MOSP;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_NIBR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_NIBR_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_NIBR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_OIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NOK_NIBOR_REFERENCE_BANKS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.NIBO;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CZK_PRIBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CZK_PRIBOR_PRBO), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CZK_PRIBOR_REFERENCE_BANKS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.PRBO;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_SOFR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_SOFR_AVERAGE_180_D), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_SOFR_AVERAGE_30_D), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_SOFR_AVERAGE_90_D), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.SOFR;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SONIA), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_TERM), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_REFINITIV_TERM), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.SONA;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SEK_STIBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SEK_STIBOR_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SEK_STIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SEK_STIBOR_SIDE), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.STBO;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_BBSW_QUARTERLY_SWAP_RATE_ICAP), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_BBSW_SEMI_ANNUAL_SWAP_RATE_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_QUARTERLY_SWAP_RATE_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_QUARTERLY_SWAP_RATE_ICAP_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_SEMI_ANNUAL_SWAP_RATE_BGCANTOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_SEMI_ANNUAL_SWAP_RATE_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_SEMI_ANNUAL_SWAP_RATE_ICAP_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.AUD_SWAP_RATE_REUTERS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CAD_ISDA_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_ANNUAL_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_ANNUAL_SWAP_RATE_11_00_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CHF_ISDAFIX_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CNY_QUARTERLY_7_DAY_REPO_NON_DELIVERABLE_SWAP_RATE_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CNY_QUARTERLY_7_DAY_REPO_NON_DELIVERABLE_SWAP_RATE_TRADITION_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CNY_QUARTERLY_7_D_REPO_NDS_RATE_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CNY_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CNY_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CZK_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.CZK_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_SWAP_MARKER), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_10_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_11_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_11_00_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_11_00_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_11_00_SWAP_MARKER), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_3_MONTH), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_3_MONTH_SWAP_MARKER), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_4_15_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ICE_SWAP_RATE_11_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.EUR_EURIBOR_ICE_SWAP_RATE_12_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_ISDA_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_LIBOR_ICE_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_11_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_4_15_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_11_00_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SEMI_ANNUAL_SWAP_RATE_SWAP_MARKER_26), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_ICE_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.GBP_SONIA_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_ISDA_SWAP_RATE_11_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_ISDA_SWAP_RATE_4_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_ANNUAL_SWAP_RATE_11_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_ANNUAL_SWAP_RATE_4_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_QUARTERLY_SWAP_RATE_11_00_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_QUARTERLY_SWAP_RATE_4_00_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.HKD_QUARTERLY_QUARTERLY_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.IDR_SEMI_ANNUAL_SWAP_RATE_NON_DELIVERABLE_16_00_TULLETT_PREBON), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.IDR_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.IDR_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.INR_MIBOR_OIS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.INR_SEMI_ANNUAL_SWAP_RATE_NON_DELIVERABLE_16_00_TULLETT_PREBON), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.INR_SEMI_ANNUAL_SWAP_RATE_11_30_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.INR_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_ANNUAL_SWAP_RATE_11_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_ANNUAL_SWAP_RATE_3_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_ISDA_SWAP_RATE_10_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_ISDA_SWAP_RATE_15_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_TSR_10_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_LIBOR_TSR_15_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.KRW_QUARTERLY_ANNUAL_SWAP_RATE_3_30_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.MYR_QUARTERLY_SWAP_RATE_11_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.MYR_QUARTERLY_SWAP_RATE_TRADITION_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NZD_BKBM_FRA_SWAP_RATE_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NZD_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NZD_SEMI_ANNUAL_SWAP_RATE_BGCANTOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NZD_SWAP_RATE_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.NZD_SWAP_RATE_ICAP_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.PHP_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.PHP_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RON_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RON_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_12_45_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_4_15_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.RUB_ANNUAL_SWAP_RATE_TRADITION_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SEK_ANNUAL_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SEK_ANNUAL_SWAP_RATE_SESWFI), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_CURRENCY_BASIS_SWAP_RATE_11_00_TULLETT_PREBON), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_CURRENCY_BASIS_SWAP_RATE_16_00_TULLETT_PREBON), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_11_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_11_00_TULLETT_PREBON), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_16_00_TULLETT_PREBON), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_ICAP), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_ICAP_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.SGD_SEMI_ANNUAL_SWAP_RATE_TRADITION_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.THB_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.THB_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.TRY_ANNUAL_SWAP_RATE_11_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.TRY_ANNUAL_SWAP_RATE_11_15_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.TRY_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.TRY_SEMI_ANNUAL_SWAP_RATE_TRADITION_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.TWD_QUARTERLY_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.TWD_QUARTERLY_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_SWAP_RATE_BCMP_1), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_ANNUAL_SWAP_RATE_11_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_ANNUAL_SWAP_RATE_4_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_ISDA_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_ISDA_SWAP_RATE_3_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_ICE_SWAP_RATE_11_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_LIBOR_ICE_SWAP_RATE_15_00), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_SOFR_ICE_SWAP_RATE), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.VND_SEMI_ANNUAL_SWAP_RATE_11_00_BGCANTOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.VND_SEMI_ANNUAL_SWAP_RATE_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ZAR_QUARTERLY_SWAP_RATE_1_00_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ZAR_QUARTERLY_SWAP_RATE_5_30_TRADITION), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ZAR_QUARTERLY_SWAP_RATE_TRADITION_REFERENCE_BANKS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.SWAP;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_EUROYEN_TIBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_17096), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_17097), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_DTIBOR01), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_10_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_5_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_ALL_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_ALL_BANKS_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_TIBM_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.JPY_TIBOR_ZTIBOR), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TIBOR_ISDC), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TIBOR_REFERENCE_BANKS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.TIBO;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ILS_TELBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ILS_TELBOR_01_REUTERS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.ILS_TELBOR_REFERENCE_BANKS), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.TLBO;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_BCMP_1), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TBILL_SECONDARY_MARKET_BOND_EQUIVALENT_YIELD), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TBILL_H_15), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TBILL_H_15_BLOOMBERG), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TBILL_SECONDARY_MARKET), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_ICAP_BROKER_TEC), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_SWAP_MARKER_100), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_SWAP_MARKER_99), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_T_19901), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_RATE_T_500), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.USD_TREASURY_19901_3_00_ICAP), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.TREA;
			} else if (areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.PLN_WIBOR), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.PLN_WIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.PLN_WIBOR_WIBO), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.PLZ_WIBOR_REFERENCE_BANKS), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(floatingRateIndexISDA), MapperS.of(FloatingRateIndexEnum.PLZ_WIBOR_WIBO), CardinalityOperator.All)).getOrDefault(false)) {
				floatingRateIndexISO = ISOFloatingRateIndexEnum.WIBO;
			} else {
				floatingRateIndexISO = null;
			}
			
			return floatingRateIndexISO;
		}
	}
}
