package drr.regulation.common.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.QuantityReportablePeriod;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class QuantityReportablePeriodValidator implements Validator<QuantityReportablePeriod> {

	private List<ComparisonResult> getComparisonResults(QuantityReportablePeriod o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("periodValue", (BigDecimal) o.getPeriodValue() != null ? 1 : 0, 1, 1), 
				checkCardinality("periodEffectiveDate", (Date) o.getPeriodEffectiveDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("periodEndDate", (Date) o.getPeriodEndDate() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, QuantityReportablePeriod o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("QuantityReportablePeriod", ValidationResult.ValidationType.CARDINALITY, "QuantityReportablePeriod", path, "", res.getError());
				}
				return success("QuantityReportablePeriod", ValidationResult.ValidationType.CARDINALITY, "QuantityReportablePeriod", path, "");
			})
			.collect(toList());
	}

}
