package drr.regulation.common.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.AdmittedToTradingVenue;
import drr.regulation.common.CommodityTimeUnitEnum;
import drr.regulation.common.ESMATransactionInformation;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ESMATransactionInformationOnlyExistsValidator implements ValidatorWithArg<ESMATransactionInformation, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ESMATransactionInformation> ValidationResult<ESMATransactionInformation> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("admittedToTradingVenue", ExistenceChecker.isSet((AdmittedToTradingVenue) o.getAdmittedToTradingVenue()))
				.put("underlierTradedOnTradingVenue", ExistenceChecker.isSet((Boolean) o.getUnderlierTradedOnTradingVenue()))
				.put("duration", ExistenceChecker.isSet((CommodityTimeUnitEnum) o.getDuration()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ESMATransactionInformation", ValidationResult.ValidationType.ONLY_EXISTS, "ESMATransactionInformation", path, "");
		}
		return failure("ESMATransactionInformation", ValidationResult.ValidationType.ONLY_EXISTS, "ESMATransactionInformation", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
