package drr.regulation.esma.emir.refit.trade.functions;

import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousQuantitySchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.GetLeg2ResolvablePriceQuantity;
import drr.regulation.common.functions.TradeForEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(EUEMIRNotionalAmountPeriodLeg2.EUEMIRNotionalAmountPeriodLeg2Default.class)
public abstract class EUEMIRNotionalAmountPeriodLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_ContinuousQuantitySchedule create_ContinuousQuantitySchedule;
	@Inject protected GetExpirationDate getExpirationDate;
	@Inject protected GetLeg2ResolvablePriceQuantity getLeg2ResolvablePriceQuantity;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param transactionReportInstruction 
	* @return emirNotionalAmountPeriods 
	*/
	public List<? extends QuantityReportablePeriod> evaluate(TransactionReportInstruction transactionReportInstruction) {
		List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirNotionalAmountPeriodsBuilder = doEvaluate(transactionReportInstruction);
		
		final List<? extends QuantityReportablePeriod> emirNotionalAmountPeriods;
		if (emirNotionalAmountPeriodsBuilder == null) {
			emirNotionalAmountPeriods = null;
		} else {
			emirNotionalAmountPeriods = emirNotionalAmountPeriodsBuilder.stream().map(QuantityReportablePeriod::build).collect(Collectors.toList());
			objectValidator.validate(QuantityReportablePeriod.class, emirNotionalAmountPeriods);
		}
		
		return emirNotionalAmountPeriods;
	}

	protected abstract List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction);

	protected abstract MapperC<? extends QuantityReportablePeriod> genericNotionalAmountSchedule(TransactionReportInstruction transactionReportInstruction);

	public static class EUEMIRNotionalAmountPeriodLeg2Default extends EUEMIRNotionalAmountPeriodLeg2 {
		@Override
		protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction) {
			List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirNotionalAmountPeriods = new ArrayList<>();
			return assignOutput(emirNotionalAmountPeriods, transactionReportInstruction);
		}
		
		protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> assignOutput(List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirNotionalAmountPeriods, TransactionReportInstruction transactionReportInstruction) {
			emirNotionalAmountPeriods = toBuilder(create_ContinuousQuantitySchedule.evaluate(genericNotionalAmountSchedule(transactionReportInstruction).getMulti(), expirationDate(transactionReportInstruction).get()));
			
			return Optional.ofNullable(emirNotionalAmountPeriods)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction) {
			return MapperS.of(getExpirationDate.evaluate(transactionReportInstruction));
		}
		
		@Override
		protected MapperC<? extends QuantityReportablePeriod> genericNotionalAmountSchedule(TransactionReportInstruction transactionReportInstruction) {
			final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> thenArg0 = MapperS.of(getLeg2ResolvablePriceQuantity.evaluate(tradeForEvent.evaluate(transactionReportInstruction))).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
			final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> exists(item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
			final MapperC<DatedValue> thenArg2 = thenArg1
				.mapSingleToList(item -> item.<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()));
			return thenArg2
				.mapItem(notionalAmountPeriod -> MapperS.of(QuantityReportablePeriod.builder()
					.setPeriodValue(notionalAmountPeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).get())
					.setPeriodEffectiveDate(notionalAmountPeriod.<Date>map("getDate", datedValue -> datedValue.getDate()).get())
					.setPeriodEndDate(null)
					.build()));
		}
	}
}
