package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.esma.emir.refit.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.esma.emir.refit.trade.functions.EUEMIRNotionalAmountPeriodLeg1;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountScheduleLeg1Rule.NotionalAmountScheduleLeg1RuleDefault.class)
public abstract class NotionalAmountScheduleLeg1Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalAmountScheduleLeg1Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EUEMIRNotionalAmountPeriodLeg1 eUEMIRNotionalAmountPeriodLeg1;
	@Inject protected EffectiveDateOfTheNotionalAmountOfLeg1Rule effectiveDateOfTheNotionalAmountOfLeg1Rule;
	@Inject protected EndDateOfTheNotionalAmountOfLeg1Rule endDateOfTheNotionalAmountOfLeg1Rule;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg1Rule notionalAmountInEffectOnAssociatedEffectiveDateOfLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalAmountScheduleLeg1Report> evaluate(TransactionReportInstruction input) {
		List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalAmountScheduleLeg1Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalAmountScheduleLeg1Report::build).collect(Collectors.toList());
			objectValidator.validate(NotionalAmountScheduleLeg1Report.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalAmountScheduleLeg1RuleDefault extends NotionalAmountScheduleLeg1Rule {
		@Override
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> assignOutput(List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperC<QuantityReportablePeriod> thenArg1 = thenArg0
				.mapSingleToList(item -> MapperC.<QuantityReportablePeriod>of(eUEMIRNotionalAmountPeriodLeg1.evaluate(item.get())));
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(NotionalAmountScheduleLeg1Report.builder()
					.setAmount(notionalAmountInEffectOnAssociatedEffectiveDateOfLeg1Rule.evaluate(item.get()))
					.setEffectiveDate(effectiveDateOfTheNotionalAmountOfLeg1Rule.evaluate(item.get()))
					.setEndDate(endDateOfTheNotionalAmountOfLeg1Rule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
