package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import drr.standards.iso.PriceNotationEnum;


@ImplementedBy(StrikePriceNotationInEffectOnAssociatedEffectiveDateRule.StrikePriceNotationInEffectOnAssociatedEffectiveDateRuleDefault.class)
public abstract class StrikePriceNotationInEffectOnAssociatedEffectiveDateRule implements ReportFunction<PriceReportablePeriod, PriceNotationEnum> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(PriceReportablePeriod input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(PriceReportablePeriod input);

	public static class StrikePriceNotationInEffectOnAssociatedEffectiveDateRuleDefault extends StrikePriceNotationInEffectOnAssociatedEffectiveDateRule {
		@Override
		protected PriceNotationEnum doEvaluate(PriceReportablePeriod input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, PriceReportablePeriod input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<PriceAndNotation>map("getPeriodValue", priceReportablePeriod -> priceReportablePeriod.getPeriodValue()).<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation())).get();
			
			return output;
		}
	}
}
