package drr.regulation.esma.emir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.StrikePriceAndNotation;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class StrikePriceAndNotationValidator implements Validator<StrikePriceAndNotation> {

	private List<ComparisonResult> getComparisonResults(StrikePriceAndNotation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("strikePriceMonetary", (BigDecimal) o.getStrikePriceMonetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePricePercentage", (BigDecimal) o.getStrikePricePercentage() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceCurrency", (String) o.getStrikePriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceNotation", (PriceNotationEnum) o.getStrikePriceNotation() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrikePriceAndNotation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("StrikePriceAndNotation", ValidationResult.ValidationType.CARDINALITY, "StrikePriceAndNotation", path, "", res.getError());
				}
				return success("StrikePriceAndNotation", ValidationResult.ValidationType.CARDINALITY, "StrikePriceAndNotation", path, "");
			})
			.collect(toList());
	}

}
