package drr.regulation.esma.emir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.StrikePriceScheduleReport;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class StrikePriceScheduleReportValidator implements Validator<StrikePriceScheduleReport> {

	private List<ComparisonResult> getComparisonResults(StrikePriceScheduleReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("effectiveDateStrikePrice", (Date) o.getEffectiveDateStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("endDateStrikePrice", (Date) o.getEndDateStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceInEffectOnAssociatedEffectiveDateMonetary", (BigDecimal) o.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceInEffectOnAssociatedEffectiveDatePercentage", (BigDecimal) o.getStrikePriceInEffectOnAssociatedEffectiveDatePercentage() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceNotationInEffectOnAssociatedEffectiveDate", (PriceNotationEnum) o.getStrikePriceNotationInEffectOnAssociatedEffectiveDate() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrikePriceScheduleReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("StrikePriceScheduleReport", ValidationResult.ValidationType.CARDINALITY, "StrikePriceScheduleReport", path, "", res.getError());
				}
				return success("StrikePriceScheduleReport", ValidationResult.ValidationType.CARDINALITY, "StrikePriceScheduleReport", path, "");
			})
			.collect(toList());
	}

}
