package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2048_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2048_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2048_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2048_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if (\"FORW\" = contractType and assetClass = \"COMM\") or ([\"FORW\", \"SWAP\"] any = contractType and assetClass = \"EQUI\") or [\"CFDS\", \"FUTR\"] any = contractType then price exists";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2048_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (areEqual(MapperS.of("FORW"), MapperS.of(eSMAEMIRTransactionReport).<String>map("getContractType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getContractType()), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(eSMAEMIRTransactionReport).<String>map("getAssetClass", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getAssetClass()), MapperS.of("COMM"), CardinalityOperator.All)).orNullSafe(areEqual(MapperC.<String>of(MapperS.of("FORW"), MapperS.of("SWAP")), MapperS.of(eSMAEMIRTransactionReport).<String>map("getContractType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getContractType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(eSMAEMIRTransactionReport).<String>map("getAssetClass", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getAssetClass()), MapperS.of("EQUI"), CardinalityOperator.All))).orNullSafe(areEqual(MapperC.<String>of(MapperS.of("CFDS"), MapperS.of("FUTR")), MapperS.of(eSMAEMIRTransactionReport).<String>map("getContractType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getContractType()), CardinalityOperator.Any)).getOrDefault(false)) {
						return exists(MapperS.of(eSMAEMIRTransactionReport).<PriceAndNotation>map("getPrice", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPrice()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2048_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
