package drr.regulation.esma.emir.refit.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.esma.emir.refit.trade.DeliveryReport;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRNonReportable;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.esma.emir.refit.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.esma.emir.refit.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.esma.emir.refit.trade.NotionalQuantityScheduleLeg2Report;
import drr.regulation.esma.emir.refit.trade.OtherPaymentReport;
import drr.regulation.esma.emir.refit.trade.PackageTransactionPrice;
import drr.regulation.esma.emir.refit.trade.PackageTransactionSpread;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import drr.regulation.esma.emir.refit.trade.PriceScheduleReport;
import drr.regulation.esma.emir.refit.trade.SpreadOfLeg1;
import drr.regulation.esma.emir.refit.trade.SpreadOfLeg2;
import drr.regulation.esma.emir.refit.trade.StrikePriceAndNotation;
import drr.regulation.esma.emir.refit.trade.StrikePriceScheduleReport;
import iso20022.auth030.esma.EnergyLoadType1Code;
import iso20022.auth030.esma.Frequency13Code__1;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import iso20022.auth030.esma.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ESMAEMIRTransactionReportOnlyExistsValidator implements ValidatorWithArg<ESMAEMIRTransactionReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ESMAEMIRTransactionReport> ValidationResult<ESMAEMIRTransactionReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("reportSubmittingEntityID", ExistenceChecker.isSet((String) o.getReportSubmittingEntityID()))
				.put("entityResponsibleForReporting", ExistenceChecker.isSet((String) o.getEntityResponsibleForReporting()))
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("natureOfCounterparty1", ExistenceChecker.isSet((String) o.getNatureOfCounterparty1()))
				.put("corporateSectorOfTheCounterparty1", ExistenceChecker.isSet((List<String>) o.getCorporateSectorOfTheCounterparty1()))
				.put("clearingThresholdOfCounterparty1", ExistenceChecker.isSet((Boolean) o.getClearingThresholdOfCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("countryOfTheCounterParty2", ExistenceChecker.isSet((ISOCountryCodeEnum) o.getCountryOfTheCounterParty2()))
				.put("natureOfCounterparty2", ExistenceChecker.isSet((String) o.getNatureOfCounterparty2()))
				.put("corporateSectorOfTheCounterparty2", ExistenceChecker.isSet((List<String>) o.getCorporateSectorOfTheCounterparty2()))
				.put("counterparty2IdentifierType", ExistenceChecker.isSet((Boolean) o.getCounterparty2IdentifierType()))
				.put("clearingMember", ExistenceChecker.isSet((String) o.getClearingMember()))
				.put("clearingThresholdOfCounterparty2", ExistenceChecker.isSet((Boolean) o.getClearingThresholdOfCounterparty2()))
				.put("reportingObligationOfTheCounterparty2", ExistenceChecker.isSet((Boolean) o.getReportingObligationOfTheCounterparty2()))
				.put("brokerID", ExistenceChecker.isSet((String) o.getBrokerID()))
				.put("direction", ExistenceChecker.isSet((String) o.getDirection()))
				.put("directionOfLeg1", ExistenceChecker.isSet((String) o.getDirectionOfLeg1()))
				.put("directionOfLeg2", ExistenceChecker.isSet((String) o.getDirectionOfLeg2()))
				.put("directlyLinkedToCommercialActivityOrTreasuryFinancing", ExistenceChecker.isSet((Boolean) o.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing()))
				.put("uti", ExistenceChecker.isSet((String) o.getUti()))
				.put("utiProprietary", ExistenceChecker.isSet((String) o.getUtiProprietary()))
				.put("reportTrackingNumber", ExistenceChecker.isSet((String) o.getReportTrackingNumber()))
				.put("priorUti", ExistenceChecker.isSet((String) o.getPriorUti()))
				.put("priorUtiProprietary", ExistenceChecker.isSet((String) o.getPriorUtiProprietary()))
				.put("ptrrId", ExistenceChecker.isSet((String) o.getPtrrId()))
				.put("packageIdentifier", ExistenceChecker.isSet((String) o.getPackageIdentifier()))
				.put("subsequentPositionUti", ExistenceChecker.isSet((String) o.getSubsequentPositionUti()))
				.put("isin", ExistenceChecker.isSet((String) o.getIsin()))
				.put("upi", ExistenceChecker.isSet((String) o.getUpi()))
				.put("productClassification", ExistenceChecker.isSet((String) o.getProductClassification()))
				.put("contractType", ExistenceChecker.isSet((String) o.getContractType()))
				.put("assetClass", ExistenceChecker.isSet((String) o.getAssetClass()))
				.put("isCrypto", ExistenceChecker.isSet((Boolean) o.getIsCrypto()))
				.put("underlyingIdentificationType", ExistenceChecker.isSet((String) o.getUnderlyingIdentificationType()))
				.put("underlyingIdentification", ExistenceChecker.isSet((String) o.getUnderlyingIdentification()))
				.put("nameOfTheUnderlyingIndex", ExistenceChecker.isSet((List<String>) o.getNameOfTheUnderlyingIndex()))
				.put("indicatorOfTheUnderlyingIndex", ExistenceChecker.isSet((List<String>) o.getIndicatorOfTheUnderlyingIndex()))
				.put("identifierOfBasketConstituents", ExistenceChecker.isSet((List<String>) o.getIdentifierOfBasketConstituents()))
				.put("customBasketCode", ExistenceChecker.isSet((String) o.getCustomBasketCode()))
				.put("settlementCurrency1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrency1()))
				.put("settlementCurrency2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrency2()))
				.put("valuationAmount", ExistenceChecker.isSet((BigDecimal) o.getValuationAmount()))
				.put("valuationCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getValuationCurrency()))
				.put("valuationMethod", ExistenceChecker.isSet((ValuationType1Code) o.getValuationMethod()))
				.put("delta", ExistenceChecker.isSet((BigDecimal) o.getDelta()))
				.put("valuationTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getValuationTimestamp()))
				.put("confirmationTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getConfirmationTimestamp()))
				.put("confirmed", ExistenceChecker.isSet((String) o.getConfirmed()))
				.put("clearingObligation", ExistenceChecker.isSet((String) o.getClearingObligation()))
				.put("cleared", ExistenceChecker.isSet((String) o.getCleared()))
				.put("clearingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getClearingTimestamp()))
				.put("centralCounterparty", ExistenceChecker.isSet((String) o.getCentralCounterparty()))
				.put("masterAgreementType", ExistenceChecker.isSet((String) o.getMasterAgreementType()))
				.put("otherMasterAgreementType", ExistenceChecker.isSet((String) o.getOtherMasterAgreementType()))
				.put("masterAgreementVersion", ExistenceChecker.isSet((Integer) o.getMasterAgreementVersion()))
				.put("intragroup", ExistenceChecker.isSet((Boolean) o.getIntragroup()))
				.put("ptrr", ExistenceChecker.isSet((Boolean) o.getPtrr()))
				.put("typeOfPTRRTechnique", ExistenceChecker.isSet((String) o.getTypeOfPTRRTechnique()))
				.put("ptrrServiceProvider", ExistenceChecker.isSet((String) o.getPtrrServiceProvider()))
				.put("venueOfExecution", ExistenceChecker.isSet((String) o.getVenueOfExecution()))
				.put("executionTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getExecutionTimestamp()))
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.put("expirationDate", ExistenceChecker.isSet((Date) o.getExpirationDate()))
				.put("earlyTerminationDate", ExistenceChecker.isSet((Date) o.getEarlyTerminationDate()))
				.put("finalContractualSettlementDate", ExistenceChecker.isSet((Date) o.getFinalContractualSettlementDate()))
				.put("deliveryType", ExistenceChecker.isSet((String) o.getDeliveryType()))
				.put("price", ExistenceChecker.isSet((PriceAndNotation) o.getPrice()))
				.put("priceSchedule", ExistenceChecker.isSet((List<? extends PriceScheduleReport>) o.getPriceSchedule()))
				.put("packageTransactionPrice", ExistenceChecker.isSet((PackageTransactionPrice) o.getPackageTransactionPrice()))
				.put("notionalLeg1", ExistenceChecker.isSet((BigDecimal) o.getNotionalLeg1()))
				.put("notionalCurrency1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrency1()))
				.put("notionalAmountScheduleLeg1", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg1Report>) o.getNotionalAmountScheduleLeg1()))
				.put("totalNotionalQuantityLeg1", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg1()))
				.put("notionalQuantityScheduleLeg1", ExistenceChecker.isSet((List<? extends NotionalQuantityScheduleLeg1Report>) o.getNotionalQuantityScheduleLeg1()))
				.put("totalNotionalQuantityLeg2", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg2()))
				.put("notionalLeg2", ExistenceChecker.isSet((BigDecimal) o.getNotionalLeg2()))
				.put("notionalCurrency2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrency2()))
				.put("notionalAmountScheduleLeg2", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg2Report>) o.getNotionalAmountScheduleLeg2()))
				.put("notionalQuantityScheduleLeg2", ExistenceChecker.isSet((List<? extends NotionalQuantityScheduleLeg2Report>) o.getNotionalQuantityScheduleLeg2()))
				.put("otherPayment", ExistenceChecker.isSet((List<? extends OtherPaymentReport>) o.getOtherPayment()))
				.put("fixedRateOfLeg1", ExistenceChecker.isSet((BigDecimal) o.getFixedRateOfLeg1()))
				.put("fixedRateDayCountConventionLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg1()))
				.put("fixedRatePaymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getFixedRatePaymentFrequencyPeriodLeg1()))
				.put("fixedRatePaymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1()))
				.put("identifierOfFloatingRateOfLeg1", ExistenceChecker.isSet((String) o.getIdentifierOfFloatingRateOfLeg1()))
				.put("indicatorOfTheFloatingRateOfLeg1", ExistenceChecker.isSet((String) o.getIndicatorOfTheFloatingRateOfLeg1()))
				.put("nameOfTheFloatingRateOfLeg1", ExistenceChecker.isSet((String) o.getNameOfTheFloatingRateOfLeg1()))
				.put("floatingRateDayCountConventionOfLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg1()))
				.put("floatingRatePaymentFrequencyPeriodOfLeg1", ExistenceChecker.isSet((Frequency13Code__1) o.getFloatingRatePaymentFrequencyPeriodOfLeg1()))
				.put("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1", ExistenceChecker.isSet((Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()))
				.put("floatingRateReferencePeriodOfLeg1TimePeriod", ExistenceChecker.isSet((String) o.getFloatingRateReferencePeriodOfLeg1TimePeriod()))
				.put("floatingRateReferencePeriodOfLeg1Multiplier", ExistenceChecker.isSet((Integer) o.getFloatingRateReferencePeriodOfLeg1Multiplier()))
				.put("floatingRateResetFrequencyPeriodOfLeg1", ExistenceChecker.isSet((String) o.getFloatingRateResetFrequencyPeriodOfLeg1()))
				.put("floatingRateResetFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg1()))
				.put("spreadOfLeg1", ExistenceChecker.isSet((SpreadOfLeg1) o.getSpreadOfLeg1()))
				.put("fixedRateOfLeg2", ExistenceChecker.isSet((BigDecimal) o.getFixedRateOfLeg2()))
				.put("fixedRateDayCountConventionLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg2()))
				.put("fixedRatePaymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getFixedRatePaymentFrequencyPeriodLeg2()))
				.put("fixedRatePaymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2()))
				.put("identifierOfFloatingRateOfLeg2", ExistenceChecker.isSet((String) o.getIdentifierOfFloatingRateOfLeg2()))
				.put("indicatorOfTheFloatingRateOfLeg2", ExistenceChecker.isSet((String) o.getIndicatorOfTheFloatingRateOfLeg2()))
				.put("nameOfTheFloatingRateOfLeg2", ExistenceChecker.isSet((String) o.getNameOfTheFloatingRateOfLeg2()))
				.put("floatingRateDayCountConventionOfLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg2()))
				.put("floatingRatePaymentFrequencyPeriodOfLeg2", ExistenceChecker.isSet((String) o.getFloatingRatePaymentFrequencyPeriodOfLeg2()))
				.put("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2", ExistenceChecker.isSet((Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()))
				.put("floatingRateReferencePeriodOfLeg2TimePeriod", ExistenceChecker.isSet((String) o.getFloatingRateReferencePeriodOfLeg2TimePeriod()))
				.put("floatingRateReferencePeriodOfLeg2Multiplier", ExistenceChecker.isSet((Integer) o.getFloatingRateReferencePeriodOfLeg2Multiplier()))
				.put("floatingRateResetFrequencyPeriodOfLeg2", ExistenceChecker.isSet((String) o.getFloatingRateResetFrequencyPeriodOfLeg2()))
				.put("floatingRateResetFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg2()))
				.put("spreadOfLeg2", ExistenceChecker.isSet((SpreadOfLeg2) o.getSpreadOfLeg2()))
				.put("packageTransactionSpread", ExistenceChecker.isSet((PackageTransactionSpread) o.getPackageTransactionSpread()))
				.put("exchangeRate", ExistenceChecker.isSet((BigDecimal) o.getExchangeRate()))
				.put("forwardExchangeRate", ExistenceChecker.isSet((BigDecimal) o.getForwardExchangeRate()))
				.put("exchangeRateBasis", ExistenceChecker.isSet((String) o.getExchangeRateBasis()))
				.put("baseProduct", ExistenceChecker.isSet((String) o.getBaseProduct()))
				.put("subProduct", ExistenceChecker.isSet((String) o.getSubProduct()))
				.put("furtherSubProduct", ExistenceChecker.isSet((String) o.getFurtherSubProduct()))
				.put("deliveryPoint", ExistenceChecker.isSet((List<String>) o.getDeliveryPoint()))
				.put("interconnectionPoint", ExistenceChecker.isSet((String) o.getInterconnectionPoint()))
				.put("loadType", ExistenceChecker.isSet((EnergyLoadType1Code) o.getLoadType()))
				.put("deliveryReport", ExistenceChecker.isSet((List<? extends DeliveryReport>) o.getDeliveryReport()))
				.put("optionType", ExistenceChecker.isSet((String) o.getOptionType()))
				.put("optionStyle", ExistenceChecker.isSet((String) o.getOptionStyle()))
				.put("strikePrice", ExistenceChecker.isSet((StrikePriceAndNotation) o.getStrikePrice()))
				.put("strikePriceSchedule", ExistenceChecker.isSet((List<? extends StrikePriceScheduleReport>) o.getStrikePriceSchedule()))
				.put("optionPremiumAmount", ExistenceChecker.isSet((BigDecimal) o.getOptionPremiumAmount()))
				.put("optionPremiumCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getOptionPremiumCurrency()))
				.put("optionPremiumPaymentDate", ExistenceChecker.isSet((Date) o.getOptionPremiumPaymentDate()))
				.put("maturityDateOfTheUnderlying", ExistenceChecker.isSet((Date) o.getMaturityDateOfTheUnderlying()))
				.put("seniority", ExistenceChecker.isSet((String) o.getSeniority()))
				.put("referenceEntity", ExistenceChecker.isSet((String) o.getReferenceEntity()))
				.put("series", ExistenceChecker.isSet((Integer) o.getSeries()))
				.put("version", ExistenceChecker.isSet((Integer) o.getVersion()))
				.put("indexFactor", ExistenceChecker.isSet((BigDecimal) o.getIndexFactor()))
				.put("tranche", ExistenceChecker.isSet((Boolean) o.getTranche()))
				.put("cdSIndexAttachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCdSIndexAttachmentPoint()))
				.put("cdSIndexDetachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCdSIndexDetachmentPoint()))
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("collateralPortfolioCode", ExistenceChecker.isSet((String) o.getCollateralPortfolioCode()))
				.put("actionType", ExistenceChecker.isSet((String) o.getActionType()))
				.put("eventType", ExistenceChecker.isSet((String) o.getEventType()))
				.put("eventDate", ExistenceChecker.isSet((Date) o.getEventDate()))
				.put("level", ExistenceChecker.isSet((String) o.getLevel()))
				.put("nonReportable", ExistenceChecker.isSet((ESMAEMIRNonReportable) o.getNonReportable()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ESMAEMIRTransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "ESMAEMIRTransactionReport", path, "");
		}
		return failure("ESMAEMIRTransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "ESMAEMIRTransactionReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
