package drr.regulation.fca.ukemir.refit.margin.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.margin.PartiesToTheDerivative;
import drr.regulation.fca.ukemir.refit.margin.validation.PartiesToTheDerivativeTypeFormatValidator;
import drr.regulation.fca.ukemir.refit.margin.validation.PartiesToTheDerivativeValidator;
import drr.regulation.fca.ukemir.refit.margin.validation.exists.PartiesToTheDerivativeOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.55.0
 */
@RosettaMeta(model=PartiesToTheDerivative.class)
public class PartiesToTheDerivativeMeta implements RosettaMetaData<PartiesToTheDerivative> {

	@Override
	public List<Validator<? super PartiesToTheDerivative>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super PartiesToTheDerivative, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super PartiesToTheDerivative> validator(ValidatorFactory factory) {
		return factory.<PartiesToTheDerivative>create(PartiesToTheDerivativeValidator.class);
	}

	@Override
	public Validator<? super PartiesToTheDerivative> typeFormatValidator(ValidatorFactory factory) {
		return factory.<PartiesToTheDerivative>create(PartiesToTheDerivativeTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super PartiesToTheDerivative> validator() {
		return new PartiesToTheDerivativeValidator();
	}

	@Deprecated
	@Override
	public Validator<? super PartiesToTheDerivative> typeFormatValidator() {
		return new PartiesToTheDerivativeTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super PartiesToTheDerivative, Set<String>> onlyExistsValidator() {
		return new PartiesToTheDerivativeOnlyExistsValidator();
	}
}
