package drr.regulation.fca.ukemir.refit.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.fca.ukemir.refit.trade.meta.NotionalAmountScheduleLeg2ReportMeta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="NotionalAmountScheduleLeg2Report", builder=NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilderImpl.class, version="5.55.0")
@RuneDataType(value="NotionalAmountScheduleLeg2Report", model="drr", builder=NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilderImpl.class, version="5.55.0")
public interface NotionalAmountScheduleLeg2Report extends RosettaModelObject {

	NotionalAmountScheduleLeg2ReportMeta metaData = new NotionalAmountScheduleLeg2ReportMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getAmount();
	Date getEffectiveDate();
	Date getEndDate();

	/*********************** Build Methods  ***********************/
	NotionalAmountScheduleLeg2Report build();
	
	NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder toBuilder();
	
	static NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder builder() {
		return new NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends NotionalAmountScheduleLeg2Report> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends NotionalAmountScheduleLeg2Report> getType() {
		return NotionalAmountScheduleLeg2Report.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("amount"), BigDecimal.class, getAmount(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface NotionalAmountScheduleLeg2ReportBuilder extends NotionalAmountScheduleLeg2Report, RosettaModelObjectBuilder {
		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder setAmount(BigDecimal amount);
		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder setEffectiveDate(Date effectiveDate);
		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder setEndDate(Date endDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("amount"), BigDecimal.class, getAmount(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
		}
		

		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder prune();
	}

	/*********************** Immutable Implementation of NotionalAmountScheduleLeg2Report  ***********************/
	class NotionalAmountScheduleLeg2ReportImpl implements NotionalAmountScheduleLeg2Report {
		private final BigDecimal amount;
		private final Date effectiveDate;
		private final Date endDate;
		
		protected NotionalAmountScheduleLeg2ReportImpl(NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder builder) {
			this.amount = builder.getAmount();
			this.effectiveDate = builder.getEffectiveDate();
			this.endDate = builder.getEndDate();
		}
		
		@Override
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		public BigDecimal getAmount() {
			return amount;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report build() {
			return this;
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder toBuilder() {
			NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder builder) {
			ofNullable(getAmount()).ifPresent(builder::setAmount);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getEndDate()).ifPresent(builder::setEndDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NotionalAmountScheduleLeg2Report _that = getType().cast(o);
		
			if (!Objects.equals(amount, _that.getAmount())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amount != null ? amount.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NotionalAmountScheduleLeg2Report {" +
				"amount=" + this.amount + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate +
			'}';
		}
	}

	/*********************** Builder Implementation of NotionalAmountScheduleLeg2Report  ***********************/
	class NotionalAmountScheduleLeg2ReportBuilderImpl implements NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder {
	
		protected BigDecimal amount;
		protected Date effectiveDate;
		protected Date endDate;
		
		@Override
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		public BigDecimal getAmount() {
			return amount;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder setAmount(BigDecimal _amount) {
			this.amount = _amount == null ? null : _amount;
			return this;
		}
		
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder setEndDate(Date _endDate) {
			this.endDate = _endDate == null ? null : _endDate;
			return this;
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report build() {
			return new NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportImpl(this);
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getAmount()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getEndDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder o = (NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder) other;
			
			
			merger.mergeBasic(getAmount(), o.getAmount(), this::setAmount);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getEndDate(), o.getEndDate(), this::setEndDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NotionalAmountScheduleLeg2Report _that = getType().cast(o);
		
			if (!Objects.equals(amount, _that.getAmount())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amount != null ? amount.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NotionalAmountScheduleLeg2ReportBuilder {" +
				"amount=" + this.amount + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate +
			'}';
		}
	}
}
