package drr.regulation.fca.ukemir.refit.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.fca.ukemir.refit.trade.meta.PackageTransactionSpreadMeta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="PackageTransactionSpread", builder=PackageTransactionSpread.PackageTransactionSpreadBuilderImpl.class, version="5.55.0")
@RuneDataType(value="PackageTransactionSpread", model="drr", builder=PackageTransactionSpread.PackageTransactionSpreadBuilderImpl.class, version="5.55.0")
public interface PackageTransactionSpread extends RosettaModelObject {

	PackageTransactionSpreadMeta metaData = new PackageTransactionSpreadMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getPackageTransactionSpreadMonetary();
	BigDecimal getPackageTransactionSpreadPercentage();
	BigDecimal getPackageTransactionSpreadBasis();
	PriceNotationEnum getPackageTransactionSpreadNotation();
	ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency();

	/*********************** Build Methods  ***********************/
	PackageTransactionSpread build();
	
	PackageTransactionSpread.PackageTransactionSpreadBuilder toBuilder();
	
	static PackageTransactionSpread.PackageTransactionSpreadBuilder builder() {
		return new PackageTransactionSpread.PackageTransactionSpreadBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PackageTransactionSpread> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PackageTransactionSpread> getType() {
		return PackageTransactionSpread.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("packageTransactionSpreadMonetary"), BigDecimal.class, getPackageTransactionSpreadMonetary(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadPercentage"), BigDecimal.class, getPackageTransactionSpreadPercentage(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadBasis"), BigDecimal.class, getPackageTransactionSpreadBasis(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PackageTransactionSpreadBuilder extends PackageTransactionSpread, RosettaModelObjectBuilder {
		PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadMonetary(BigDecimal packageTransactionSpreadMonetary);
		PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadPercentage(BigDecimal packageTransactionSpreadPercentage);
		PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadBasis(BigDecimal packageTransactionSpreadBasis);
		PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("packageTransactionSpreadMonetary"), BigDecimal.class, getPackageTransactionSpreadMonetary(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadPercentage"), BigDecimal.class, getPackageTransactionSpreadPercentage(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadBasis"), BigDecimal.class, getPackageTransactionSpreadBasis(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		}
		

		PackageTransactionSpread.PackageTransactionSpreadBuilder prune();
	}

	/*********************** Immutable Implementation of PackageTransactionSpread  ***********************/
	class PackageTransactionSpreadImpl implements PackageTransactionSpread {
		private final BigDecimal packageTransactionSpreadMonetary;
		private final BigDecimal packageTransactionSpreadPercentage;
		private final BigDecimal packageTransactionSpreadBasis;
		private final PriceNotationEnum packageTransactionSpreadNotation;
		private final ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
		
		protected PackageTransactionSpreadImpl(PackageTransactionSpread.PackageTransactionSpreadBuilder builder) {
			this.packageTransactionSpreadMonetary = builder.getPackageTransactionSpreadMonetary();
			this.packageTransactionSpreadPercentage = builder.getPackageTransactionSpreadPercentage();
			this.packageTransactionSpreadBasis = builder.getPackageTransactionSpreadBasis();
			this.packageTransactionSpreadNotation = builder.getPackageTransactionSpreadNotation();
			this.packageTransactionSpreadCurrency = builder.getPackageTransactionSpreadCurrency();
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadMonetary")
		@RuneAttribute("packageTransactionSpreadMonetary")
		public BigDecimal getPackageTransactionSpreadMonetary() {
			return packageTransactionSpreadMonetary;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadPercentage")
		@RuneAttribute("packageTransactionSpreadPercentage")
		public BigDecimal getPackageTransactionSpreadPercentage() {
			return packageTransactionSpreadPercentage;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadBasis")
		@RuneAttribute("packageTransactionSpreadBasis")
		public BigDecimal getPackageTransactionSpreadBasis() {
			return packageTransactionSpreadBasis;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public PriceNotationEnum getPackageTransactionSpreadNotation() {
			return packageTransactionSpreadNotation;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
			return packageTransactionSpreadCurrency;
		}
		
		@Override
		public PackageTransactionSpread build() {
			return this;
		}
		
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder toBuilder() {
			PackageTransactionSpread.PackageTransactionSpreadBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PackageTransactionSpread.PackageTransactionSpreadBuilder builder) {
			ofNullable(getPackageTransactionSpreadMonetary()).ifPresent(builder::setPackageTransactionSpreadMonetary);
			ofNullable(getPackageTransactionSpreadPercentage()).ifPresent(builder::setPackageTransactionSpreadPercentage);
			ofNullable(getPackageTransactionSpreadBasis()).ifPresent(builder::setPackageTransactionSpreadBasis);
			ofNullable(getPackageTransactionSpreadNotation()).ifPresent(builder::setPackageTransactionSpreadNotation);
			ofNullable(getPackageTransactionSpreadCurrency()).ifPresent(builder::setPackageTransactionSpreadCurrency);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PackageTransactionSpread _that = getType().cast(o);
		
			if (!Objects.equals(packageTransactionSpreadMonetary, _that.getPackageTransactionSpreadMonetary())) return false;
			if (!Objects.equals(packageTransactionSpreadPercentage, _that.getPackageTransactionSpreadPercentage())) return false;
			if (!Objects.equals(packageTransactionSpreadBasis, _that.getPackageTransactionSpreadBasis())) return false;
			if (!Objects.equals(packageTransactionSpreadNotation, _that.getPackageTransactionSpreadNotation())) return false;
			if (!Objects.equals(packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (packageTransactionSpreadMonetary != null ? packageTransactionSpreadMonetary.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadPercentage != null ? packageTransactionSpreadPercentage.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadBasis != null ? packageTransactionSpreadBasis.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadNotation != null ? packageTransactionSpreadNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadCurrency != null ? packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PackageTransactionSpread {" +
				"packageTransactionSpreadMonetary=" + this.packageTransactionSpreadMonetary + ", " +
				"packageTransactionSpreadPercentage=" + this.packageTransactionSpreadPercentage + ", " +
				"packageTransactionSpreadBasis=" + this.packageTransactionSpreadBasis + ", " +
				"packageTransactionSpreadNotation=" + this.packageTransactionSpreadNotation + ", " +
				"packageTransactionSpreadCurrency=" + this.packageTransactionSpreadCurrency +
			'}';
		}
	}

	/*********************** Builder Implementation of PackageTransactionSpread  ***********************/
	class PackageTransactionSpreadBuilderImpl implements PackageTransactionSpread.PackageTransactionSpreadBuilder {
	
		protected BigDecimal packageTransactionSpreadMonetary;
		protected BigDecimal packageTransactionSpreadPercentage;
		protected BigDecimal packageTransactionSpreadBasis;
		protected PriceNotationEnum packageTransactionSpreadNotation;
		protected ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
		
		@Override
		@RosettaAttribute("packageTransactionSpreadMonetary")
		@RuneAttribute("packageTransactionSpreadMonetary")
		public BigDecimal getPackageTransactionSpreadMonetary() {
			return packageTransactionSpreadMonetary;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadPercentage")
		@RuneAttribute("packageTransactionSpreadPercentage")
		public BigDecimal getPackageTransactionSpreadPercentage() {
			return packageTransactionSpreadPercentage;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadBasis")
		@RuneAttribute("packageTransactionSpreadBasis")
		public BigDecimal getPackageTransactionSpreadBasis() {
			return packageTransactionSpreadBasis;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public PriceNotationEnum getPackageTransactionSpreadNotation() {
			return packageTransactionSpreadNotation;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
			return packageTransactionSpreadCurrency;
		}
		
		@RosettaAttribute("packageTransactionSpreadMonetary")
		@RuneAttribute("packageTransactionSpreadMonetary")
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadMonetary(BigDecimal _packageTransactionSpreadMonetary) {
			this.packageTransactionSpreadMonetary = _packageTransactionSpreadMonetary == null ? null : _packageTransactionSpreadMonetary;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadPercentage")
		@RuneAttribute("packageTransactionSpreadPercentage")
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadPercentage(BigDecimal _packageTransactionSpreadPercentage) {
			this.packageTransactionSpreadPercentage = _packageTransactionSpreadPercentage == null ? null : _packageTransactionSpreadPercentage;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadBasis")
		@RuneAttribute("packageTransactionSpreadBasis")
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadBasis(BigDecimal _packageTransactionSpreadBasis) {
			this.packageTransactionSpreadBasis = _packageTransactionSpreadBasis == null ? null : _packageTransactionSpreadBasis;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		public PackageTransactionSpread build() {
			return new PackageTransactionSpread.PackageTransactionSpreadImpl(this);
		}
		
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPackageTransactionSpreadMonetary()!=null) return true;
			if (getPackageTransactionSpreadPercentage()!=null) return true;
			if (getPackageTransactionSpreadBasis()!=null) return true;
			if (getPackageTransactionSpreadNotation()!=null) return true;
			if (getPackageTransactionSpreadCurrency()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PackageTransactionSpread.PackageTransactionSpreadBuilder o = (PackageTransactionSpread.PackageTransactionSpreadBuilder) other;
			
			
			merger.mergeBasic(getPackageTransactionSpreadMonetary(), o.getPackageTransactionSpreadMonetary(), this::setPackageTransactionSpreadMonetary);
			merger.mergeBasic(getPackageTransactionSpreadPercentage(), o.getPackageTransactionSpreadPercentage(), this::setPackageTransactionSpreadPercentage);
			merger.mergeBasic(getPackageTransactionSpreadBasis(), o.getPackageTransactionSpreadBasis(), this::setPackageTransactionSpreadBasis);
			merger.mergeBasic(getPackageTransactionSpreadNotation(), o.getPackageTransactionSpreadNotation(), this::setPackageTransactionSpreadNotation);
			merger.mergeBasic(getPackageTransactionSpreadCurrency(), o.getPackageTransactionSpreadCurrency(), this::setPackageTransactionSpreadCurrency);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PackageTransactionSpread _that = getType().cast(o);
		
			if (!Objects.equals(packageTransactionSpreadMonetary, _that.getPackageTransactionSpreadMonetary())) return false;
			if (!Objects.equals(packageTransactionSpreadPercentage, _that.getPackageTransactionSpreadPercentage())) return false;
			if (!Objects.equals(packageTransactionSpreadBasis, _that.getPackageTransactionSpreadBasis())) return false;
			if (!Objects.equals(packageTransactionSpreadNotation, _that.getPackageTransactionSpreadNotation())) return false;
			if (!Objects.equals(packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (packageTransactionSpreadMonetary != null ? packageTransactionSpreadMonetary.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadPercentage != null ? packageTransactionSpreadPercentage.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadBasis != null ? packageTransactionSpreadBasis.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadNotation != null ? packageTransactionSpreadNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadCurrency != null ? packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PackageTransactionSpreadBuilder {" +
				"packageTransactionSpreadMonetary=" + this.packageTransactionSpreadMonetary + ", " +
				"packageTransactionSpreadPercentage=" + this.packageTransactionSpreadPercentage + ", " +
				"packageTransactionSpreadBasis=" + this.packageTransactionSpreadBasis + ", " +
				"packageTransactionSpreadNotation=" + this.packageTransactionSpreadNotation + ", " +
				"packageTransactionSpreadCurrency=" + this.packageTransactionSpreadCurrency +
			'}';
		}
	}
}
