package drr.regulation.fca.ukemir.refit.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.trade.PackageTransactionSpread;
import drr.regulation.fca.ukemir.refit.trade.validation.PackageTransactionSpreadTypeFormatValidator;
import drr.regulation.fca.ukemir.refit.trade.validation.PackageTransactionSpreadValidator;
import drr.regulation.fca.ukemir.refit.trade.validation.datarule.PackageTransactionSpreadBasis;
import drr.regulation.fca.ukemir.refit.trade.validation.datarule.PackageTransactionSpreadMonetaryCurrency;
import drr.regulation.fca.ukemir.refit.trade.validation.datarule.PackageTransactionSpreadMonetaryOrPercentageOrBasis;
import drr.regulation.fca.ukemir.refit.trade.validation.datarule.PackageTransactionSpreadPercentage;
import drr.regulation.fca.ukemir.refit.trade.validation.exists.PackageTransactionSpreadOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.55.0
 */
@RosettaMeta(model=PackageTransactionSpread.class)
public class PackageTransactionSpreadMeta implements RosettaMetaData<PackageTransactionSpread> {

	@Override
	public List<Validator<? super PackageTransactionSpread>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<PackageTransactionSpread>create(PackageTransactionSpreadMonetaryOrPercentageOrBasis.class),
			factory.<PackageTransactionSpread>create(PackageTransactionSpreadMonetaryCurrency.class),
			factory.<PackageTransactionSpread>create(PackageTransactionSpreadPercentage.class),
			factory.<PackageTransactionSpread>create(PackageTransactionSpreadBasis.class)
		);
	}
	
	@Override
	public List<Function<? super PackageTransactionSpread, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super PackageTransactionSpread> validator(ValidatorFactory factory) {
		return factory.<PackageTransactionSpread>create(PackageTransactionSpreadValidator.class);
	}

	@Override
	public Validator<? super PackageTransactionSpread> typeFormatValidator(ValidatorFactory factory) {
		return factory.<PackageTransactionSpread>create(PackageTransactionSpreadTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super PackageTransactionSpread> validator() {
		return new PackageTransactionSpreadValidator();
	}

	@Deprecated
	@Override
	public Validator<? super PackageTransactionSpread> typeFormatValidator() {
		return new PackageTransactionSpreadTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super PackageTransactionSpread, Set<String>> onlyExistsValidator() {
		return new PackageTransactionSpreadOnlyExistsValidator();
	}
}
