package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEStrikePriceScheduleEffectiveDateRule;
import javax.inject.Inject;


@ImplementedBy(EffectiveDateOfTheStrikePriceRule.EffectiveDateOfTheStrikePriceRuleDefault.class)
public abstract class EffectiveDateOfTheStrikePriceRule implements ReportFunction<PriceReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceScheduleEffectiveDateRule cDEStrikePriceScheduleEffectiveDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(PriceReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(PriceReportablePeriod input);

	public static class EffectiveDateOfTheStrikePriceRuleDefault extends EffectiveDateOfTheStrikePriceRule {
		@Override
		protected Date doEvaluate(PriceReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, PriceReportablePeriod input) {
			output = cDEStrikePriceScheduleEffectiveDateRule.evaluate(input);
			
			return output;
		}
	}
}
