package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2003_05")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2003_05.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2003_05 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2003_05";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if priorUTI exists then [uti, utiProprietary, reportTrackingNumber, subsequentPositionUTI] all <> priorUTI else [uti, utiProprietary, reportTrackingNumber, subsequentPositionUTI] all <> priorUTIProprietary";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2003_05 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTI())).getOrDefault(false)) {
						return notEqual(MapperC.<String>of(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getUti", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getUti()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getUtiProprietary", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getUtiProprietary()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getReportTrackingNumber", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getReportTrackingNumber()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getSubsequentPositionUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSubsequentPositionUTI())), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTI()), CardinalityOperator.All);
					}
					return notEqual(MapperC.<String>of(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getUti", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getUti()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getUtiProprietary", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getUtiProprietary()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getReportTrackingNumber", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getReportTrackingNumber()), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getSubsequentPositionUTI", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSubsequentPositionUTI())), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getPriorUTIProprietary", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPriorUTIProprietary()), CardinalityOperator.All);
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2003_05 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
