package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import drr.regulation.fca.ukemir.refit.trade.SpreadOfLeg1;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2093_02")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2093_02.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2093_02 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2093_02";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then (if indicatorOfTheUnderlyingIndex exists or nameOfTheFloatingRateOfLeg1 exists then (if spreadOfLeg1 -> spreadOfLeg1Notation = PriceNotationEnum -> Percentage then spreadOfLeg1 -> spreadOfLeg1Percentage exists else True) else True)";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2093_02 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(fCAUKEMIRTransactionReport).<String>mapC("getIndicatorOfTheUnderlyingIndex", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getIndicatorOfTheUnderlyingIndex())).orNullSafe(exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getNameOfTheFloatingRateOfLeg1", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getNameOfTheFloatingRateOfLeg1()))).getOrDefault(false)) {
						if (areEqual(MapperS.of(fCAUKEMIRTransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSpreadOfLeg1()).<PriceNotationEnum>map("getSpreadOfLeg1Notation", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Notation()), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
							return exists(MapperS.of(fCAUKEMIRTransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Percentage", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Percentage()));
						}
						return ComparisonResult.ofNullSafe(MapperS.of(true));
					}
					return ComparisonResult.ofNullSafe(MapperS.of(true));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2093_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
