package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.PackageTransactionSpread;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("PackageTransactionSpreadMonetaryOrPercentageOrBasis")
@ImplementedBy(PackageTransactionSpreadMonetaryOrPercentageOrBasis.Default.class)
public interface PackageTransactionSpreadMonetaryOrPercentageOrBasis extends Validator<PackageTransactionSpread> {
	
	String NAME = "PackageTransactionSpreadMonetaryOrPercentageOrBasis";
	String DEFINITION = "optional choice packageTransactionSpreadMonetary, packageTransactionSpreadPercentage, packageTransactionSpreadBasis";
	
	class Default implements PackageTransactionSpreadMonetaryOrPercentageOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread packageTransactionSpread) {
			ComparisonResult result = executeDataRule(packageTransactionSpread);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PackageTransactionSpread", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "PackageTransactionSpread", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PackageTransactionSpread packageTransactionSpread) {
			try {
				return choice(MapperS.of(packageTransactionSpread), Arrays.asList("packageTransactionSpreadMonetary", "packageTransactionSpreadPercentage", "packageTransactionSpreadBasis"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PackageTransactionSpreadMonetaryOrPercentageOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread packageTransactionSpread) {
			return Collections.emptyList();
		}
	}
}
