package drr.regulation.jfsa.rewrite.margin.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class JFSAMarginLabelProvider extends GraphBasedLabelProvider {
	public JFSAMarginLabelProvider() {
		super(new LabelNode());
		
		
		LabelNode partiesToTheDerivativeNode = new LabelNode();
		partiesToTheDerivativeNode.addLabel(Arrays.asList("reportingTimestamp"), "4 Reporting Timestamp");
		partiesToTheDerivativeNode.addLabel(Arrays.asList("submitterIdentifier"), "12 Submitter Identifier");
		partiesToTheDerivativeNode.addLabel(Arrays.asList("entityResponsibleForReporting"), "6 Entity responsible for reporting");
		partiesToTheDerivativeNode.addLabel(Arrays.asList("counterparty1"), "7 Counterparty 1 (reporting counterparty)");
		partiesToTheDerivativeNode.addLabel(Arrays.asList("counterparty2IdentifierType"), "9 Counterparty 2 identifier type");
		partiesToTheDerivativeNode.addLabel(Arrays.asList("counterparty2"), "8 Counterparty 2");
		
		LabelNode collateralReportNode = new LabelNode();
		collateralReportNode.addLabel(Arrays.asList("collateralPortfolioIndicator"), "44 Collateral portfolio indicator");
		collateralReportNode.addLabel(Arrays.asList("uti"), "25 Unique transaction identifier (UTI)");
		collateralReportNode.addLabel(Arrays.asList("collateralisationCategory"), "61 Collateralisation category");
		collateralReportNode.addLabel(Arrays.asList("initialMarginCollateralPortfolioCode"), "62 Initial margin Collateral portfolio code");
		collateralReportNode.addLabel(Arrays.asList("initialMarginPostedByTheReportingCounterpartyPreHaircut"), "45 Initial margin posted by the reporting counterparty (pre-haircut)");
		collateralReportNode.addLabel(Arrays.asList("initialMarginPostedByTheReportingCounterpartyPostHaircut"), "46 Initial margin posted by the reporting counterparty (post-haircut)");
		collateralReportNode.addLabel(Arrays.asList("currencyofInitialMarginPosted"), "47 Currency of the initial margins posted");
		collateralReportNode.addLabel(Arrays.asList("initialMarginCollectedByReportingCounterpartyPreHaircut"), "48 Initial margin collected by the reporting counterparty (pre-haircut)");
		collateralReportNode.addLabel(Arrays.asList("initialMarginCollectedByReportingCounterpartyPostHaircut"), "49 Initial margin collected by the reporting counterparty (post-haircut)");
		collateralReportNode.addLabel(Arrays.asList("currencyofInitialMarginCollected"), "50 Currency of initial margin collected");
		collateralReportNode.addLabel(Arrays.asList("variationMarginCollateralPortfolioCode"), "63 Variation Margin Collateral portfolio code");
		collateralReportNode.addLabel(Arrays.asList("variationMarginPostedByTheReportingCounterpartyPreHaircut"), "51 Variation margin posted by the reporting counterparty (pre-haircut)");
		collateralReportNode.addLabel(Arrays.asList("variationMarginPostedByTheReportingCounterpartyPostHaircut"), "52 Variation margin posted by the reporting counterparty (post-haircut)");
		collateralReportNode.addLabel(Arrays.asList("currencyOfVariationMarginPosted"), "53 Currency of the variation margins posted");
		collateralReportNode.addLabel(Arrays.asList("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), "54 Variation margin collected by the reporting counterparty (pre-haircut)");
		collateralReportNode.addLabel(Arrays.asList("variationMarginCollectedByTheReportingCounterpartyPostHaircut"), "55 Variation margin collected by the reporting counterparty (post-haircut)");
		collateralReportNode.addLabel(Arrays.asList("currencyOfVariationMarginCollected"), "56 Currency of variation margin collected");
		collateralReportNode.addLabel(Arrays.asList("excessCollateralPostedByTheReportingCounterparty"), "57 Excess collateral posted by the reporting counterparty");
		collateralReportNode.addLabel(Arrays.asList("currencyOfTheExcessCollateralPosted"), "58 Currency of the excess collateral posted");
		collateralReportNode.addLabel(Arrays.asList("excessCollateralCollectedByTheReportingCounterparty"), "59 Excess Collateral Collected By The reporting counterparty");
		collateralReportNode.addLabel(Arrays.asList("currencyOfTheExcessCollateralCollected"), "60 Currency of excess collateral collected");
		collateralReportNode.addLabel(Arrays.asList("eventTimestamp"), "104 Event timestamp");
		collateralReportNode.addLabel(Arrays.asList("actionType"), "101 Action Type");
		collateralReportNode.addLabel(Arrays.asList("technicalRecordId"), "[Internal] Technical Record Id (ISO)");
		
		startNode.addOutgoingEdge("partiesToTheDerivative", partiesToTheDerivativeNode);
		startNode.addOutgoingEdge("collateral", collateralReportNode);
	}
}
