package drr.regulation.jfsa.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.jfsa.rewrite.trade.meta.JFSANonReportableMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="JFSANonReportable", builder=JFSANonReportable.JFSANonReportableBuilderImpl.class, version="5.55.0")
@RuneDataType(value="JFSANonReportable", model="drr", builder=JFSANonReportable.JFSANonReportableBuilderImpl.class, version="5.55.0")
public interface JFSANonReportable extends RosettaModelObject {

	JFSANonReportableMeta metaData = new JFSANonReportableMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Populated by pre-enrichment process
	 */
	EnrichmentData getEnrichment();

	/*********************** Build Methods  ***********************/
	JFSANonReportable build();
	
	JFSANonReportable.JFSANonReportableBuilder toBuilder();
	
	static JFSANonReportable.JFSANonReportableBuilder builder() {
		return new JFSANonReportable.JFSANonReportableBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends JFSANonReportable> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends JFSANonReportable> getType() {
		return JFSANonReportable.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.class, getEnrichment());
	}
	

	/*********************** Builder Interface  ***********************/
	interface JFSANonReportableBuilder extends JFSANonReportable, RosettaModelObjectBuilder {
		EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment();
		@Override
		EnrichmentData.EnrichmentDataBuilder getEnrichment();
		JFSANonReportable.JFSANonReportableBuilder setEnrichment(EnrichmentData enrichment);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.EnrichmentDataBuilder.class, getEnrichment());
		}
		

		JFSANonReportable.JFSANonReportableBuilder prune();
	}

	/*********************** Immutable Implementation of JFSANonReportable  ***********************/
	class JFSANonReportableImpl implements JFSANonReportable {
		private final EnrichmentData enrichment;
		
		protected JFSANonReportableImpl(JFSANonReportable.JFSANonReportableBuilder builder) {
			this.enrichment = ofNullable(builder.getEnrichment()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public EnrichmentData getEnrichment() {
			return enrichment;
		}
		
		@Override
		public JFSANonReportable build() {
			return this;
		}
		
		@Override
		public JFSANonReportable.JFSANonReportableBuilder toBuilder() {
			JFSANonReportable.JFSANonReportableBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(JFSANonReportable.JFSANonReportableBuilder builder) {
			ofNullable(getEnrichment()).ifPresent(builder::setEnrichment);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			JFSANonReportable _that = getType().cast(o);
		
			if (!Objects.equals(enrichment, _that.getEnrichment())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (enrichment != null ? enrichment.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "JFSANonReportable {" +
				"enrichment=" + this.enrichment +
			'}';
		}
	}

	/*********************** Builder Implementation of JFSANonReportable  ***********************/
	class JFSANonReportableBuilderImpl implements JFSANonReportable.JFSANonReportableBuilder {
	
		protected EnrichmentData.EnrichmentDataBuilder enrichment;
		
		@Override
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		public EnrichmentData.EnrichmentDataBuilder getEnrichment() {
			return enrichment;
		}
		
		@Override
		public EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment() {
			EnrichmentData.EnrichmentDataBuilder result;
			if (enrichment!=null) {
				result = enrichment;
			}
			else {
				result = enrichment = EnrichmentData.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute("enrichment")
		@RuneAttribute("enrichment")
		@Override
		public JFSANonReportable.JFSANonReportableBuilder setEnrichment(EnrichmentData _enrichment) {
			this.enrichment = _enrichment == null ? null : _enrichment.toBuilder();
			return this;
		}
		
		@Override
		public JFSANonReportable build() {
			return new JFSANonReportable.JFSANonReportableImpl(this);
		}
		
		@Override
		public JFSANonReportable.JFSANonReportableBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public JFSANonReportable.JFSANonReportableBuilder prune() {
			if (enrichment!=null && !enrichment.prune().hasData()) enrichment = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEnrichment()!=null && getEnrichment().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public JFSANonReportable.JFSANonReportableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			JFSANonReportable.JFSANonReportableBuilder o = (JFSANonReportable.JFSANonReportableBuilder) other;
			
			merger.mergeRosetta(getEnrichment(), o.getEnrichment(), this::setEnrichment);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			JFSANonReportable _that = getType().cast(o);
		
			if (!Objects.equals(enrichment, _that.getEnrichment())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (enrichment != null ? enrichment.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "JFSANonReportableBuilder {" +
				"enrichment=" + this.enrichment +
			'}';
		}
	}
}
