package drr.regulation.jfsa.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.jfsa.rewrite.trade.meta.PriceScheduleReportMeta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="PriceScheduleReport", builder=PriceScheduleReport.PriceScheduleReportBuilderImpl.class, version="5.55.0")
@RuneDataType(value="PriceScheduleReport", model="drr", builder=PriceScheduleReport.PriceScheduleReportBuilderImpl.class, version="5.55.0")
public interface PriceScheduleReport extends RosettaModelObject {

	PriceScheduleReportMeta metaData = new PriceScheduleReportMeta();

	/*********************** Getter Methods  ***********************/
	Date getEffectiveDate();
	Date getEndDate();
	BigDecimal getPriceMonetary();
	BigDecimal getPriceDecimal();

	/*********************** Build Methods  ***********************/
	PriceScheduleReport build();
	
	PriceScheduleReport.PriceScheduleReportBuilder toBuilder();
	
	static PriceScheduleReport.PriceScheduleReportBuilder builder() {
		return new PriceScheduleReport.PriceScheduleReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PriceScheduleReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PriceScheduleReport> getType() {
		return PriceScheduleReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
		processor.processBasic(path.newSubPath("priceMonetary"), BigDecimal.class, getPriceMonetary(), this);
		processor.processBasic(path.newSubPath("priceDecimal"), BigDecimal.class, getPriceDecimal(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PriceScheduleReportBuilder extends PriceScheduleReport, RosettaModelObjectBuilder {
		PriceScheduleReport.PriceScheduleReportBuilder setEffectiveDate(Date effectiveDate);
		PriceScheduleReport.PriceScheduleReportBuilder setEndDate(Date endDate);
		PriceScheduleReport.PriceScheduleReportBuilder setPriceMonetary(BigDecimal priceMonetary);
		PriceScheduleReport.PriceScheduleReportBuilder setPriceDecimal(BigDecimal priceDecimal);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
			processor.processBasic(path.newSubPath("priceMonetary"), BigDecimal.class, getPriceMonetary(), this);
			processor.processBasic(path.newSubPath("priceDecimal"), BigDecimal.class, getPriceDecimal(), this);
		}
		

		PriceScheduleReport.PriceScheduleReportBuilder prune();
	}

	/*********************** Immutable Implementation of PriceScheduleReport  ***********************/
	class PriceScheduleReportImpl implements PriceScheduleReport {
		private final Date effectiveDate;
		private final Date endDate;
		private final BigDecimal priceMonetary;
		private final BigDecimal priceDecimal;
		
		protected PriceScheduleReportImpl(PriceScheduleReport.PriceScheduleReportBuilder builder) {
			this.effectiveDate = builder.getEffectiveDate();
			this.endDate = builder.getEndDate();
			this.priceMonetary = builder.getPriceMonetary();
			this.priceDecimal = builder.getPriceDecimal();
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		public BigDecimal getPriceMonetary() {
			return priceMonetary;
		}
		
		@Override
		@RosettaAttribute("priceDecimal")
		@RuneAttribute("priceDecimal")
		public BigDecimal getPriceDecimal() {
			return priceDecimal;
		}
		
		@Override
		public PriceScheduleReport build() {
			return this;
		}
		
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder toBuilder() {
			PriceScheduleReport.PriceScheduleReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PriceScheduleReport.PriceScheduleReportBuilder builder) {
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getEndDate()).ifPresent(builder::setEndDate);
			ofNullable(getPriceMonetary()).ifPresent(builder::setPriceMonetary);
			ofNullable(getPriceDecimal()).ifPresent(builder::setPriceDecimal);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PriceScheduleReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			if (!Objects.equals(priceMonetary, _that.getPriceMonetary())) return false;
			if (!Objects.equals(priceDecimal, _that.getPriceDecimal())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			_result = 31 * _result + (priceMonetary != null ? priceMonetary.hashCode() : 0);
			_result = 31 * _result + (priceDecimal != null ? priceDecimal.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PriceScheduleReport {" +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate + ", " +
				"priceMonetary=" + this.priceMonetary + ", " +
				"priceDecimal=" + this.priceDecimal +
			'}';
		}
	}

	/*********************** Builder Implementation of PriceScheduleReport  ***********************/
	class PriceScheduleReportBuilderImpl implements PriceScheduleReport.PriceScheduleReportBuilder {
	
		protected Date effectiveDate;
		protected Date endDate;
		protected BigDecimal priceMonetary;
		protected BigDecimal priceDecimal;
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		public BigDecimal getPriceMonetary() {
			return priceMonetary;
		}
		
		@Override
		@RosettaAttribute("priceDecimal")
		@RuneAttribute("priceDecimal")
		public BigDecimal getPriceDecimal() {
			return priceDecimal;
		}
		
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder setEndDate(Date _endDate) {
			this.endDate = _endDate == null ? null : _endDate;
			return this;
		}
		
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder setPriceMonetary(BigDecimal _priceMonetary) {
			this.priceMonetary = _priceMonetary == null ? null : _priceMonetary;
			return this;
		}
		
		@RosettaAttribute("priceDecimal")
		@RuneAttribute("priceDecimal")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder setPriceDecimal(BigDecimal _priceDecimal) {
			this.priceDecimal = _priceDecimal == null ? null : _priceDecimal;
			return this;
		}
		
		@Override
		public PriceScheduleReport build() {
			return new PriceScheduleReport.PriceScheduleReportImpl(this);
		}
		
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEffectiveDate()!=null) return true;
			if (getEndDate()!=null) return true;
			if (getPriceMonetary()!=null) return true;
			if (getPriceDecimal()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PriceScheduleReport.PriceScheduleReportBuilder o = (PriceScheduleReport.PriceScheduleReportBuilder) other;
			
			
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getEndDate(), o.getEndDate(), this::setEndDate);
			merger.mergeBasic(getPriceMonetary(), o.getPriceMonetary(), this::setPriceMonetary);
			merger.mergeBasic(getPriceDecimal(), o.getPriceDecimal(), this::setPriceDecimal);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PriceScheduleReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			if (!Objects.equals(priceMonetary, _that.getPriceMonetary())) return false;
			if (!Objects.equals(priceDecimal, _that.getPriceDecimal())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			_result = 31 * _result + (priceMonetary != null ? priceMonetary.hashCode() : 0);
			_result = 31 * _result + (priceDecimal != null ? priceDecimal.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PriceScheduleReportBuilder {" +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate + ", " +
				"priceMonetary=" + this.priceMonetary + ", " +
				"priceDecimal=" + this.priceDecimal +
			'}';
		}
	}
}
